package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.datasouce.NbDataSource;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.SnowflakeIdApplier;
import cn.hperfect.nbquerier.core.components.route.ISchemaRoute;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import cn.hperfect.nbquerier.spring.transaction.SpringTransactionFactory;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * 自动化配置
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 9:48 上午
 */
@Configuration
@Import({SpringUtil.class})
@EnableTransactionManagement
@EnableConfigurationProperties(NbQuerierProperties.class)
public class NbQuerierAutoConfiguration {

    private final NbQuerierConfiguration configuration;

    @Bean
    public NbQuerierConfiguration nbQuerierConfiguration() {
        return configuration;
    }

    @Configuration
    public static class DataAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public ITransactionFactory transactionFactory() {
            return new SpringTransactionFactory();
        }


        @Bean
        @ConditionalOnMissingBean
        public INbDataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
            return new NbDataSource(dynamicDataSourceProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        public Snowflake snowflake(NbQuerierProperties nbQuerierProperties) {
            return new Snowflake(nbQuerierProperties.getWorkerId(), nbQuerierProperties.getDataCenterId());
        }

        @Bean
        @ConditionalOnMissingBean
        public SnowflakeIdApplier snowIdApplier(Snowflake snowflake) {
            return new SnowflakeIdApplier(snowflake);
        }
    }

    public NbQuerierAutoConfiguration(NbQuerierProperties nbQuerierProperties,
                                      INbDataSource dataSource,
                                      SnowflakeIdApplier snowflakeIdApplier,
                                      @Autowired(required = false) ISqlMapperBuilder sqlMapperBuilder,
                                      ITransactionFactory transactionFactory,
                                      @Autowired(required = false) ISchemaRoute schemaRoute) {

        configuration = NbQuerierConfigFactory.INSTANCE.init(nbQuerierProperties, transactionFactory, dataSource);
        configuration.setSqlMapperBuilder(sqlMapperBuilder);
        //初始化厂库
        configuration.getFieldFillStrategyRegistry().init(snowflakeIdApplier);
        configuration.setSchemaRoute(schemaRoute);

    }

    @Bean
    NbExecutorFactory nbExecutorFactory() {
        return new NbExecutorFactory(configuration);
    }

    /*INbExecutor nbExecutor() {
        return configuration.newNbExecutor();
    }*/

    @Bean
    FieldFillStrategyRegistry fieldFillStrategyRegistry() {
        return configuration.getFieldFillStrategyRegistry();
    }

    @Bean
    public ValidatorRegistry validatorRegistry() {
        return configuration.getValidatorRegistry();
    }

    @Bean
    NbInterceptorRegistry nbInterceptorRegistry() {
        return configuration.getNbInterceptorRegistry();
    }

    @Bean
    public INbQueryBuilder nbQueryBuilder() {
        return configuration.getNbQueryBuilder();
    }


}
