/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NbEnumUtils {
    public static Object getEnumNewValue(List<? extends INbField> fields, Object value, String name) {
        Map<String, Object> nbEnumType = NbEnumUtils.getNbEnumType(fields, name);
        Object o = NbEnumUtils.getEnumNewValue(value, nbEnumType);
        if (o != null) {
            return o;
        }
        return value;
    }

    private static Object getEnumNewValue(Object value, Map<String, Object> nbEnumType) {
        if (CollUtil.isNotEmpty(nbEnumType) && value != null && value instanceof String) {
            Object o = nbEnumType.get(value);
            if (o == null) {
                throw new NbSQLMessageException("\u503c:{},\u4e0d\u5408\u6cd5,\u53ef\u7528\u503c:{}", value, nbEnumType);
            }
            return o;
        }
        return value;
    }

    public static List<Object> getEnumListNewValue(List<? extends INbField> fields, Collection<?> valueList, String name) {
        Map<String, Object> nbEnumType = NbEnumUtils.getNbEnumType(fields, name);
        ArrayList<Object> newValue = new ArrayList<Object>();
        if (CollUtil.isNotEmpty(nbEnumType)) {
            for (Object v : valueList) {
                newValue.add(NbEnumUtils.getEnumNewValue(v, nbEnumType));
            }
        }
        return newValue;
    }

    public static Map<String, Object> getNbEnumType(List<? extends INbField> fields, String name) {
        INbField one = (INbField)CollUtil.findOne(fields, i -> i.getName().equals(name));
        assert (one instanceof ClassNbField) : "\u679a\u4e3e\u5c5e\u6027\u672a\u627e\u5230,\u5c5e\u6027\u540d\u79f0:" + name;
        ClassNbField classNbField = (ClassNbField)one;
        return classNbField.getEnumMap();
    }
}

