/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hperfect.nbquerier.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<String, WeakReference<SerializedLambda>>();

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        String name = clazz.getName();
        return Optional.ofNullable(FUNC_CACHE.get(name)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(name, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }
}

