/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.metedata.QueryItem;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FieldParseUtils {
    public static List<QueryItem> parse(String str, boolean parseFunc) {
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        StrBuilder sql = new StrBuilder();
        Stack<QueryItem> itemStack = new Stack<QueryItem>();
        QueryItem curr = new QueryItem();
        boolean sqlStart = true;
        StrBuilder builder = new StrBuilder();
        for (char ch : str.toCharArray()) {
            if (sqlStart) {
                sql.append(ch);
            }
            if ('(' == ch) {
                curr.setFunc(true);
                curr.setFuncName(FieldParseUtils.getToken(builder));
                if (itemStack.empty()) {
                    sqlStart = true;
                    items.add(curr);
                }
                itemStack.push(curr);
                curr = new QueryItem();
                continue;
            }
            if (')' == ch) {
                Assert.isTrue((!itemStack.empty() ? 1 : 0) != 0, (String)"\u62ec\u53f7\u4e0d\u5339\u914d", (Object[])new Object[0]);
                QueryItem pop = (QueryItem)itemStack.pop();
                if (!builder.isEmpty()) {
                    curr.setName(FieldParseUtils.getToken(builder));
                    pop.addParam(curr);
                    curr = new QueryItem();
                }
                if (!itemStack.empty()) continue;
                sqlStart = false;
                continue;
            }
            if ('.' == ch) {
                Assert.notNull((Object)curr, (String)"\u4e0d\u80fd\u4ee5.\u5f00\u5934", (Object[])new Object[0]);
                curr.setTableAlias(FieldParseUtils.getToken(builder));
                continue;
            }
            if (',' == ch) {
                if (itemStack.empty()) {
                    FieldParseUtils.finishOnce(parseFunc, builder, sql, curr);
                    sqlStart = true;
                    items.add(curr);
                    curr = new QueryItem();
                    continue;
                }
                if (builder.isEmpty()) continue;
                curr.setName(builder.toString());
                ((QueryItem)itemStack.peek()).addParam(curr);
                curr = new QueryItem();
                continue;
            }
            builder.append(ch);
        }
        FieldParseUtils.finishOnce(parseFunc, builder, sql, curr);
        return items;
    }

    private static String getToken(StrBuilder builder) {
        return builder.toString(true);
    }

    private static void finishOnce(boolean parseFunc, StrBuilder builder, StrBuilder sql, QueryItem queryItem) {
        if (!sql.isEmpty() && !parseFunc && queryItem.isFunc()) {
            queryItem.setSql(FieldParseUtils.getToken(sql));
        }
        if (!queryItem.isFunc()) {
            queryItem.setName(FieldParseUtils.getToken(builder));
        }
    }

    public static void main(String[] args) {
        StopWatch stopWatch = new StopWatch();
        List<Object> test = new ArrayList();
        stopWatch.start("\u89e3\u6790\u5b57\u6bb5");
        for (int i = 0; i < 1; ++i) {
            test = FieldParseUtils.simpleParse("ev.view_id, v.table_id, ev.table_id, coalesce(v.title, ev.title) title,view_label");
        }
        for (QueryItem queryItem : test) {
            System.out.println(queryItem.getExpr());
        }
        stopWatch.stop();
    }

    public static List<QueryItem> simpleParse(String str) {
        StrBuilder builder = new StrBuilder();
        StrBuilder sql = new StrBuilder();
        StrBuilder fieldAlias = new StrBuilder();
        boolean aliasStart = false;
        boolean lastIsS = false;
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        QueryItem curr = new QueryItem();
        int level = 0;
        for (char ch : str.toCharArray()) {
            if (ch == '(') {
                boolean isFunc;
                boolean bl = isFunc = !builder.isEmpty();
                if (isFunc) {
                    ++level;
                    curr.setFunc(true);
                }
            } else if (ch == ')') {
                if (curr.isFunc()) {
                    --level;
                }
            } else if (level == 0) {
                if (ch == ' ') {
                    if (aliasStart && !fieldAlias.isEmpty()) {
                        aliasStart = false;
                    } else if (!builder.isEmpty()) {
                        aliasStart = true;
                    }
                } else if (lastIsS && ('A' == ch || 'a' == ch)) {
                    aliasStart = true;
                    int length = builder.length();
                    builder.del(length - 1, length);
                } else if (ch == '.') {
                    curr.setTableAlias(StrUtil.toUnderlineCase((CharSequence)FieldParseUtils.getToken(builder)));
                } else if (ch == ',') {
                    FieldParseUtils.addItem(sql, builder, fieldAlias, items, curr);
                    curr = new QueryItem();
                    lastIsS = false;
                    aliasStart = false;
                } else {
                    boolean bl = lastIsS = 's' == ch || 'S' == ch;
                    if (aliasStart) {
                        fieldAlias.append(ch);
                    } else {
                        builder.append(ch);
                    }
                }
            }
            if (',' == ch && level <= 0) continue;
            sql.append(ch);
        }
        if (!builder.isEmpty()) {
            FieldParseUtils.addItem(sql, builder, fieldAlias, items, curr);
        }
        return items;
    }

    private static void addItem(StrBuilder sql, StrBuilder builder, StrBuilder fieldAlias, List<QueryItem> items, QueryItem curr) {
        if (curr.isFunc()) {
            curr.setSql(FieldParseUtils.getToken(sql));
            curr.setFieldAlias(fieldAlias.toString(true));
        } else {
            curr.setName(FieldParseUtils.getToken(builder));
            curr.setFieldAlias(fieldAlias.toString(true));
        }
        builder.clear();
        sql.clear();
        items.add(curr);
    }
}

