/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.enums;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.enums.SqlKeyword;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.util.EnumUtil;
import java.util.LinkedHashMap;
import java.util.Objects;

public enum QueryRuleEnum implements ISqlSegment
{
    GT(">", "gt", SqlKeyword.GT),
    GE(">=", "ge", SqlKeyword.GE),
    LT("<", "lt", SqlKeyword.LT),
    LE("<=", "le", SqlKeyword.LE),
    EQ("=", "eq", SqlKeyword.EQ),
    NE("!=", "ne", SqlKeyword.NE),
    IN("IN", "in", SqlKeyword.IN),
    NOT_IN("NOT IN", "!in", SqlKeyword.NOT_IN),
    LIKE("LIKE", "like", SqlKeyword.LIKE),
    NOT_NULL("NOT_NULL", "!null", SqlKeyword.IS_NOT_NULL),
    NULL("NULL", "null", SqlKeyword.IS_NULL),
    BETWEEN("BETWEEN", "bt", SqlKeyword.BETWEEN),
    ANY("SQL", "any", null),
    NOT_ANY("SQL", "any", null),
    SQL("SQL", "sql", null),
    EMPTY("SQL", "emp", null),
    NOT_EMPTY("SQL", "emp", null),
    BLANK("SQL", "emp", null),
    NOT_BLANK("SQL", "emp", null),
    INTERS("&&", null, () -> "&&"),
    EXISTS("SQL", null, SqlKeyword.EXISTS);

    private final String sql;
    private String value;
    private final String condition;

    private QueryRuleEnum(String value, String condition, ISqlSegment sqlSegment) {
        this.value = value;
        this.condition = condition;
        this.sql = sqlSegment != null ? sqlSegment.getSqlSegment() : null;
    }

    public static QueryRuleEnum parse(String condition) {
        LinkedHashMap enumMap = EnumUtil.getEnumMap(QueryRuleEnum.class);
        for (QueryRuleEnum ruleEnum : enumMap.values()) {
            if (!Objects.equals(condition, ruleEnum.getCondition()) && !Objects.equals(condition, ruleEnum.getValue())) continue;
            return ruleEnum;
        }
        throw new NbSQLMessageException("\u4e0d\u652f\u6301\u6761\u4ef6:[{}]\u67e5\u8be2", condition);
    }

    @Override
    public String getSqlSegment() {
        return this.sql;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCondition() {
        return this.condition;
    }
}

