/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.querier.execute;

import cn.hperfect.nbquerier.core.metedata.custom.BaseCustomEntity;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.querier.condition.DoLambdaCondition;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface DoUpdate<T>
extends DoLambdaCondition<T> {
    default public int update(Map<String, Object> updateData) {
        if (CollUtil.isEmpty(updateData)) {
            return 0;
        }
        boolean allowSetNull = this.getQueryInfo().isAllowSetNull();
        if (this.getQueryInfo().isClass()) {
            this.mapFieldAlias(updateData, true);
        }
        updateData.forEach((k, v) -> {
            if (v != null || allowSetNull) {
                this.set((String)k, v);
            }
        });
        return this.update();
    }

    default public <F extends T> int save(F t) {
        return this.save(this.beanToMap(t));
    }

    default public int saveBatch(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return 0;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (T t : list) {
            dataList.add(this.beanToMap(t));
        }
        return this.saveBatchMap(dataList);
    }

    default public int updateById(T t) {
        Map<String, Object> map = this.beanToMap(t);
        return this.updateById(map);
    }

    default public int updateById(Map<String, Object> map) {
        String pkName = this.getPkName();
        Object pkValue = map.get(pkName);
        Assert.notNull((Object)pkValue, (String)"id:{},\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{pkName});
        this.where(pkName, pkValue, true);
        if (CollUtil.isEmpty(map)) {
            return 0;
        }
        return this.update(map);
    }

    default public int saveOrUpdate(T t) {
        return this.saveOrUpdate(t, true);
    }

    default public int saveOrUpdate(T t, boolean checkExist) {
        boolean update;
        if (t == null) {
            return 0;
        }
        Map<String, Object> map = this.beanToMap(t);
        Object pkValue = map.get(this.getPkName());
        boolean bl = update = pkValue != null;
        if (update && checkExist) {
            update = NbQuerier.table(this.getQueryInfo()).wherePk(pkValue).exist();
        }
        if (update) {
            return this.wherePk(pkValue).update(map);
        }
        return this.save(map);
    }

    public int update(boolean var1);

    default public int update() {
        return this.update(false);
    }

    public int delete();

    default public int delete(Object pkValue) {
        this.wherePk(pkValue);
        return this.delete();
    }

    public int save(Map<String, Object> var1);

    default public int save(BaseCustomEntity data) {
        return this.save(data.getDataMap());
    }

    public int saveBatchMap(List<Map<String, Object>> var1);

    public NbQuerier<T> set(String var1, Object var2);

    default public <V> NbQuerier<T> set(SFunction<T, V> field, V value, boolean notNull) {
        if (notNull) {
            Assert.notNull(value, (String)"\u8bbe\u7f6e\u5b57\u6bb5:{},\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{field});
        }
        return this.set(field, value);
    }

    default public <V> NbQuerier<T> set(SFunction<T, V> field, V value) {
        return this.set(this.getFieldName(field), value);
    }
}

