/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import java.util.Collection;

public class QueryValParam {
    private INbQueryType type;
    private Object value;

    public static QueryValParam stringVal(String str) {
        return new QueryValParam(NbQueryType.TEXT, str);
    }

    public static QueryValParam jsonbVal(Object value) {
        return new QueryValParam(new JsonNbType(), value);
    }

    public static QueryValParam longListVal(Collection<Long> val) {
        return new QueryValParam(NbQueryType.LONG_LIST, val);
    }

    public static QueryValParam strListVal(Collection<String> val) {
        return new QueryValParam(NbQueryType.TEXT_LIST, val);
    }

    public static QueryValParam longVal(Long val) {
        return new QueryValParam(NbQueryType.LONG, val);
    }

    public static QueryValParam intVal(Integer val) {
        return new QueryValParam(NbQueryType.INT, val);
    }

    public static QueryValParam boolVal(boolean b) {
        return new QueryValParam(NbQueryType.BOOL, b);
    }

    public INbQueryType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setType(INbQueryType type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryValParam)) {
            return false;
        }
        QueryValParam other = (QueryValParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INbQueryType this$type = this.getType();
        INbQueryType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryValParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INbQueryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "QueryValParam(type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    public QueryValParam(INbQueryType type, Object value) {
        this.type = type;
        this.value = value;
    }
}

