/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.metedata.IQueryItem;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class QueryItem
implements IQueryItem {
    private String name;
    private String tableAlias;
    private String fieldAlias;
    private boolean isFunc;
    private String funcName;
    private List<QueryItem> params;
    private QueryField queryField;
    private String sql;
    private boolean sub;

    public QueryItem(String alias, String field) {
        this.tableAlias = alias;
        this.name = field;
    }

    @Deprecated
    public QueryItem(String field) {
        this.funcName = ReUtil.get((String)"(.*)\\((.*)\\)", (CharSequence)field, (int)1);
        if (StrUtil.isNotBlank((CharSequence)this.funcName)) {
            this.isFunc = true;
            this.name = field;
        } else if (StrUtil.contains((CharSequence)field, (CharSequence)".")) {
            String[] split = field.split("\\.");
            this.tableAlias = StrUtil.toUnderlineCase((CharSequence)split[0]);
            this.name = split[1];
            if (StrUtil.containsAnyIgnoreCase((CharSequence)this.name, (CharSequence[])new CharSequence[]{" as "})) {
                String[] splitName = this.name.split(" ", 2);
                this.name = splitName[0];
                this.fieldAlias = splitName[1];
            }
        } else {
            this.name = field;
        }
        Assert.notEmpty((CharSequence)this.name, (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.name = StrUtil.toUnderlineCase((CharSequence)this.name);
    }

    @Override
    public String getExpr(String alias) {
        if (this.sql != null) {
            return this.sql;
        }
        if (this.isFunc) {
            String param = "";
            if (CollUtil.isNotEmpty(this.params)) {
                return StrUtil.join((CharSequence)",", (Iterable)this.params.stream().map(QueryItem::getExpr).collect(Collectors.toList()));
            }
            return StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{this.funcName, param});
        }
        String res = SqlUtils.withAlias(alias, this.name);
        if (StrUtil.isNotBlank((CharSequence)this.fieldAlias)) {
            res = res + " " + this.fieldAlias;
        }
        return res;
    }

    @Override
    public String getExpr() {
        return this.getExpr(this.tableAlias);
    }

    public void addParam(QueryItem param) {
        if (this.params == null) {
            this.params = new ArrayList<QueryItem>();
        }
        this.params.add(param);
    }

    public QueryItem getLastParam() {
        return (QueryItem)CollUtil.getLast(this.params);
    }

    public String getName() {
        return this.name;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getFieldAlias() {
        return this.fieldAlias;
    }

    public boolean isFunc() {
        return this.isFunc;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public List<QueryItem> getParams() {
        return this.params;
    }

    public QueryField getQueryField() {
        return this.queryField;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isSub() {
        return this.sub;
    }

    public QueryItem setName(String name) {
        this.name = name;
        return this;
    }

    public QueryItem setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
        return this;
    }

    public QueryItem setFieldAlias(String fieldAlias) {
        this.fieldAlias = fieldAlias;
        return this;
    }

    public QueryItem setFunc(boolean isFunc) {
        this.isFunc = isFunc;
        return this;
    }

    public QueryItem setFuncName(String funcName) {
        this.funcName = funcName;
        return this;
    }

    public QueryItem setParams(List<QueryItem> params) {
        this.params = params;
        return this;
    }

    public QueryItem setQueryField(QueryField queryField) {
        this.queryField = queryField;
        return this;
    }

    public QueryItem setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public QueryItem setSub(boolean sub) {
        this.sub = sub;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryItem)) {
            return false;
        }
        QueryItem other = (QueryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFunc() != other.isFunc()) {
            return false;
        }
        if (this.isSub() != other.isSub()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tableAlias = this.getTableAlias();
        String other$tableAlias = other.getTableAlias();
        if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
            return false;
        }
        String this$fieldAlias = this.getFieldAlias();
        String other$fieldAlias = other.getFieldAlias();
        if (this$fieldAlias == null ? other$fieldAlias != null : !this$fieldAlias.equals(other$fieldAlias)) {
            return false;
        }
        String this$funcName = this.getFuncName();
        String other$funcName = other.getFuncName();
        if (this$funcName == null ? other$funcName != null : !this$funcName.equals(other$funcName)) {
            return false;
        }
        List<QueryItem> this$params = this.getParams();
        List<QueryItem> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        QueryField this$queryField = this.getQueryField();
        QueryField other$queryField = other.getQueryField();
        if (this$queryField == null ? other$queryField != null : !((Object)this$queryField).equals(other$queryField)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFunc() ? 79 : 97);
        result = result * 59 + (this.isSub() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tableAlias = this.getTableAlias();
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        String $fieldAlias = this.getFieldAlias();
        result = result * 59 + ($fieldAlias == null ? 43 : $fieldAlias.hashCode());
        String $funcName = this.getFuncName();
        result = result * 59 + ($funcName == null ? 43 : $funcName.hashCode());
        List<QueryItem> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        QueryField $queryField = this.getQueryField();
        result = result * 59 + ($queryField == null ? 43 : ((Object)$queryField).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    public String toString() {
        return "QueryItem(name=" + this.getName() + ", tableAlias=" + this.getTableAlias() + ", fieldAlias=" + this.getFieldAlias() + ", isFunc=" + this.isFunc() + ", funcName=" + this.getFuncName() + ", params=" + this.getParams() + ", queryField=" + this.getQueryField() + ", sql=" + this.getSql() + ", sub=" + this.isSub() + ")";
    }

    public QueryItem() {
    }
}

