/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.interceptor.impl;

import cn.hperfect.nbquerier.core.components.interceptor.INbInterceptor;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.exceptions.ConstraintException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;

public class ConstraintInterceptor
implements INbInterceptor {
    @Override
    public void doBeforeUpdate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (!nbQueryInfo.isValidate()) {
            return;
        }
        this.validate(nbQueryInfo, dataList, true);
    }

    @Override
    public void doBeforeSave(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (!nbQueryInfo.isValidate()) {
            return;
        }
        this.validate(nbQueryInfo, dataList, false);
    }

    private void validate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList, boolean isUpdate) {
        for (INbField iNbField : nbQueryInfo.getFields()) {
            if (iNbField.getFieldType() != NbFieldType.NORMAL || !CollUtil.isNotEmpty(iNbField.getValidateRules())) continue;
            for (ValidateRule validateRule : iNbField.getValidateRules()) {
                IValidator iValidator = ValidatorRegistry.getValidator(validateRule.getName());
                Assert.notNull((Object)iValidator, (String)"\u6821\u9a8c\u5668:{},\u4e0d\u5b58\u5728", (Object[])new Object[]{validateRule.getName()});
                try {
                    if (isUpdate) {
                        iValidator.doUpdateValidate(validateRule.getParams(), nbQueryInfo, iNbField, dataList);
                        continue;
                    }
                    iValidator.doSaveValidate(validateRule.getParams(), nbQueryInfo, iNbField, dataList);
                }
                catch (ConstraintException constraintException) {
                    if (StrUtil.isNotBlank((CharSequence)validateRule.getMsg())) {
                        throw new IllegalArgumentException(validateRule.getMsg());
                    }
                    throw constraintException;
                }
            }
        }
    }
}

