/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.interceptor.components.fill;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.IFieldApplier;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.SnowflakeIdApplier;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.TimeApplier;
import java.util.HashMap;
import java.util.Map;

public class FieldFillStrategyRegistry {
    public static final String TIME_APPLIER_NAME = "NOW_TIME_APPLIER";
    public static final String SNOWFLAKE_APPLIER_NAME = "ID_APPLIER";
    private TimeApplier timeApplier;
    private SnowflakeIdApplier snowflakeIdApplier;
    private Map<String, IFieldApplier> APPLIER_MAP = new HashMap<String, IFieldApplier>();
    private FillStrategy pkStrategy;
    private FillStrategy updateTimeStrategy;
    private FillStrategy createTimeStrategy;

    public void init(SnowflakeIdApplier snowflakeIdApplier) {
        this.timeApplier = new TimeApplier();
        this.snowflakeIdApplier = snowflakeIdApplier;
        this.APPLIER_MAP.put(SNOWFLAKE_APPLIER_NAME, snowflakeIdApplier);
        this.APPLIER_MAP.put(TIME_APPLIER_NAME, this.timeApplier);
        this.pkStrategy = new FillStrategy(true, false, FillStrategy.FillType.FILL, snowflakeIdApplier);
        this.updateTimeStrategy = new FillStrategy(true, true, FillStrategy.FillType.COVER, this.timeApplier);
        this.createTimeStrategy = new FillStrategy(true, false, FillStrategy.FillType.COVER, this.timeApplier);
    }

    public FillStrategy getIdSnowflakeStrategy() {
        return this.pkStrategy;
    }

    public IFieldApplier getFieldApplier(String name) {
        return this.APPLIER_MAP.get(name);
    }

    public FillStrategy getPkStrategy() {
        return this.pkStrategy;
    }

    public void setPkStrategy(FillStrategy pkStrategy) {
        this.pkStrategy = pkStrategy;
    }

    public FillStrategy getUpdateTimeStrategy() {
        return this.updateTimeStrategy;
    }

    public void setUpdateTimeStrategy(FillStrategy updateTimeStrategy) {
        this.updateTimeStrategy = updateTimeStrategy;
    }

    public FillStrategy getCreateTimeStrategy() {
        return this.createTimeStrategy;
    }

    public void setCreateTimeStrategy(FillStrategy createTimeStrategy) {
        this.createTimeStrategy = createTimeStrategy;
    }
}

