/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.executor;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.components.executor.options.DoQueryOptions;
import cn.hperfect.nbquerier.core.components.executor.options.DoUpdateOptions;
import cn.hperfect.nbquerier.core.components.result.IResultSetHandler;
import cn.hperfect.nbquerier.core.components.result.json.NbJsonSerializer;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.INbExecuteBatch;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.ResultType;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hperfect.nbquerier.exceptions.NbSQLExecuteException;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;
import cn.hperfect.nbquerier.toolkit.SqlLoggerUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.impossibl.postgres.api.jdbc.PGType;
import java.io.Closeable;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNbExecutor
implements INbExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultNbExecutor.class);
    private final NbQuerierProperties config;
    private final INbTransaction transaction;
    private final IResultSetHandler resultSetHandler;
    private final INbSqlBuilder sqlBuilder;
    private final NbJsonSerializer jsonSerializer;

    public DefaultNbExecutor(INbTransaction tx, NbQuerierProperties config, INbSqlBuilder nbSqlBuilder, IResultSetHandler resultSetHandler, NbJsonSerializer jsonSerializer) {
        this.transaction = tx;
        this.config = config;
        this.sqlBuilder = nbSqlBuilder;
        this.resultSetHandler = resultSetHandler;
        this.jsonSerializer = jsonSerializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T doQuery(DoQueryOptions options) {
        String dsName = options.getDsName();
        ResultType resultType = options.getResultType();
        List<QueryValParam> params = options.getParams();
        String sql = options.getSql();
        TimeInterval timer = DateUtil.timer();
        Object result = null;
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.transaction.getConnection(dsName);
            PrepareSql prepareSql = this.getPrepareSql(sql, params);
            preparedStatement = connection.prepareStatement(prepareSql.getSql());
            this.setParams(prepareSql.getParams(), connection, preparedStatement);
            resultSet = preparedStatement.executeQuery();
            switch (resultType) {
                case INT: {
                    if (resultSet.next()) {
                        result = Convert.toInt((Object)resultSet.getInt(1));
                        break;
                    }
                    result = Convert.toInt((Object)0);
                    break;
                }
                case LONG: {
                    if (resultSet.next()) {
                        result = Convert.toLong((Object)resultSet.getLong(1));
                        break;
                    }
                    result = Convert.toLong((Object)0);
                    break;
                }
                case LIST: {
                    result = this.resultSetHandler.toMap(resultSet);
                    break;
                }
                case STRING: {
                    if (resultSet.next()) {
                        result = Convert.toStr((Object)resultSet.getString(1));
                    }
                    break;
                }
                case DOUBLE: {
                    if (resultSet.next()) {
                        result = Convert.toDouble((Object)resultSet.getDouble(1), (Double)0.0);
                        break;
                    }
                    result = Convert.toDouble((Object)0);
                    break;
                }
                default: {
                    throw new NbSQLException("\u4e3a\u5b9e\u73b0\u8be5\u7c7b\u578b\u67e5\u8be2:{}", new Object[]{resultType});
                }
            }
        }
        catch (Throwable throwable) {
            try {
                throw new NbSQLExecuteException(SqlLoggerUtils.logSql(sql, params), throwable);
            }
            catch (Throwable throwable2) {
                IoUtil.close(resultSet);
                IoUtil.close(preparedStatement);
                IoUtil.close((Closeable)this.transaction);
                throw throwable2;
            }
        }
        IoUtil.close((AutoCloseable)resultSet);
        IoUtil.close((AutoCloseable)preparedStatement);
        IoUtil.close((Closeable)this.transaction);
        if (this.config.isLogSql()) {
            log.info(SqlLoggerUtils.logSql(timer, sql, params));
        }
        return (T)result;
    }

    @Override
    @Deprecated
    public <T> T doQuery(String sql) {
        Connection connection = null;
        List params = ListUtil.empty();
        PreparedStatement preparedStatement = null;
        try {
            connection = this.transaction.getConnection(null);
            PrepareSql prepareSql = this.getPrepareSql(sql, params);
            preparedStatement = connection.prepareStatement(prepareSql.getSql(), 1003, 1007);
            this.setParams(prepareSql.getParams(), connection, preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                List<LinkedHashMap<String, Object>> result = this.resultSetHandler.toMap(resultSet);
                log.info("\u67e5\u51fa\u7ed3\u679c:{}", result);
            }
        }
        catch (Throwable throwable) {
            try {
                throw new NbSQLExecuteException(SqlLoggerUtils.logSql(sql, params), throwable);
            }
            catch (Throwable throwable2) {
                IoUtil.close(preparedStatement);
                IoUtil.close((Closeable)this.transaction);
                throw throwable2;
            }
        }
        IoUtil.close((AutoCloseable)preparedStatement);
        IoUtil.close((Closeable)this.transaction);
        return null;
    }

    public PrepareSql getPrepareSql(String sql, List<QueryValParam> params) {
        LinkedList<QueryValParam> paramsNew = new LinkedList<QueryValParam>();
        if (CollUtil.isNotEmpty(params)) {
            List all = ReUtil.findAll((String)"#\\{NB_PARAM_(\\d+)\\}", (CharSequence)sql, (int)0);
            for (String paramStr : all) {
                String indexStr = ReUtil.get((String)"#\\{NB_PARAM_(\\d+)\\}", (CharSequence)paramStr, (int)1);
                Assert.notBlank((CharSequence)indexStr, (String)"\u53c2\u6570\u66ff\u6362\u5931\u8d25\uff0c\u5360\u4f4d\u7b26\u4e0d\u5408\u6cd5:{}", (Object[])new Object[]{indexStr});
                sql = StrUtil.replace((CharSequence)sql, (CharSequence)paramStr, (CharSequence)"?");
                int index = Convert.toInt((Object)indexStr);
                paramsNew.add(params.get(index));
            }
        }
        return new PrepareSql(sql, paramsNew);
    }

    private void setParams(List<QueryValParam> params, Connection connection, PreparedStatement preparedStatement) throws TypeConvertException, SQLException {
        if (CollUtil.isNotEmpty(params)) {
            block5: for (int i = 0; i < params.size(); ++i) {
                QueryValParam param = params.get(i);
                INbQueryType type = param.getType();
                Assert.notNull((Object)type, (String)"\u8bbe\u7f6e\u53c2\u6570\u7684type\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Assert.notNull((Object)((Object)type.getDbDataType()), (String)"type:{},dbType\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{type});
                switch (type.getDbDataType()) {
                    case ARRAY: {
                        NbQueryType arraySubType = type.getArraySubType();
                        Object[] convert = (Object[])type.convert(param.getValue());
                        Array arrayObj = connection.createArrayOf(arraySubType.getDbTypeSql(), convert);
                        preparedStatement.setObject(i + 1, arrayObj);
                        continue block5;
                    }
                    case JSON: {
                        Object obj;
                        JsonNbType jsonNbType = (JsonNbType)type;
                        Object value = param.getValue();
                        if (value != null && jsonNbType.getJsonArray() != null) {
                            boolean isArrayValue = value instanceof Collection || value.getClass().isArray();
                            boolean jsonArray = jsonNbType.isJsonArray();
                            if (jsonArray && !isArrayValue) {
                                throw new NbSQLMessageException("json\u503c\u8bbe\u7f6e\u9519\u8bef,\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4", new Object[0]);
                            }
                            if (!jsonArray && isArrayValue) {
                                throw new NbSQLMessageException("json\u503c\u8bbe\u7f6e\u9519\u8bef,\u503c\u4e0d\u80fd\u4e3a\u6570\u7ec4", new Object[0]);
                            }
                        }
                        if (this.config.getDbType() == DbType.PG_NG) {
                            obj = type.convert(param.getValue());
                            preparedStatement.setObject(i + 1, (Object)this.jsonSerializer.serialize(obj), (SQLType)PGType.JSON);
                            continue block5;
                        }
                        if (this.config.getDbType() == DbType.POSTGRE_SQL) {
                            obj = type.convert(param.getValue());
                            PGobject pGobject = new PGobject();
                            pGobject.setValue(this.jsonSerializer.serialize(obj));
                            pGobject.setType("jsonb");
                            preparedStatement.setObject(i + 1, pGobject);
                            continue block5;
                        }
                        if (this.config.getDbType() == DbType.MYSQL) {
                            obj = type.convert(param.getValue());
                            preparedStatement.setObject(i + 1, obj);
                            continue block5;
                        }
                        throw new NbSQLMessageException("\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b:{},\u4fdd\u5b58json\u5b57\u6bb5", type);
                    }
                    case GENERAL: {
                        Object obj = type.convert(param.getValue());
                        preparedStatement.setObject(i + 1, obj);
                        continue block5;
                    }
                    default: {
                        throw new NbSQLMessageException("\u672a\u5904\u7406\u7684\u6570\u636e\u7c7b\u578b", new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public int insertBatch(NbQuerier<?> querier, List<Map<String, Object>> maps, List<QueryValParam> params) {
        if (CollUtil.isEmpty(maps)) {
            return 0;
        }
        int sum = 0;
        List groups = CollUtil.split(maps, (int)1000);
        if (groups.size() == 1) {
            String sql = this.sqlBuilder.buildSaveSql(querier, (List)groups.get(0));
            return this.doUpdate(querier.getDsName(), sql, querier.getParams(), true);
        }
        try {
            this.transaction.setAutoCommit(false);
            for (List group : groups) {
                String sql = this.sqlBuilder.buildSaveSql(querier, group);
                sum += this.doUpdate(querier.getDsName(), sql, querier.getParams(), false);
            }
            this.transaction.commit();
        }
        catch (Exception exception) {
            try {
                this.transaction.rollback();
            }
            catch (SQLException e) {
                throw new NbSQLExecuteException("\u6279\u91cf\u4fdd\u5b58\u56de\u6eda\u9519\u8bef\u9519\u8bef", e);
            }
            throw new NbSQLExecuteException("\u6279\u91cf\u4fdd\u5b58\u9519\u8bef", exception);
        }
        finally {
            IoUtil.close((Closeable)this.transaction);
        }
        return sum;
    }

    @Override
    public int doUpdate(DoUpdateOptions options) {
        boolean isBatch;
        PreparedStatement preparedStatement;
        int result;
        TimeInterval timer;
        block13: {
            String dsName = options.getDsName();
            boolean autoClose = options.isAutoClose();
            timer = DateUtil.timer();
            PrepareSql prepareSql = this.getPrepareSql(options.getSql(), options.getParams());
            INbExecuteBatch batch = options.getBatch();
            result = 0;
            Connection connection = null;
            preparedStatement = null;
            isBatch = batch != null;
            try {
                connection = this.transaction.getConnection(dsName);
                if (isBatch) {
                    this.transaction.setAutoCommit(false);
                    preparedStatement = batch.getPreparedStatement();
                    if (preparedStatement == null) {
                        preparedStatement = connection.prepareStatement(prepareSql.getSql());
                        batch.setPreparedStatement(preparedStatement);
                    }
                    this.setParams(prepareSql.getParams(), connection, preparedStatement);
                    batch.addBatch();
                } else {
                    preparedStatement = connection.prepareStatement(prepareSql.getSql());
                    this.setParams(prepareSql.getParams(), connection, preparedStatement);
                    result = preparedStatement.executeUpdate();
                }
                if (!autoClose) break block13;
            }
            catch (Throwable throwable) {
                try {
                    String message;
                    if (throwable instanceof NbSQLMessageException) {
                        throw (NbSQLMessageException)throwable;
                    }
                    if (StrUtil.isNotBlank((CharSequence)throwable.getMessage()) && this.config.getDbType() == DbType.MYSQL && StrUtil.isNotBlank((CharSequence)(message = ReUtil.get((String)"Field '(\\S+)' doesn't have a default value", (CharSequence)throwable.getMessage(), (int)1)))) {
                        throw new NbSQLMessageException("\u5b57\u6bb5:{}\u4e3a\u5fc5\u586b\u9879", message);
                    }
                    throw new NbSQLExecuteException(SqlLoggerUtils.logSql(options.getSql(), options.getParams()), throwable);
                }
                catch (Throwable throwable2) {
                    if (autoClose) {
                        IoUtil.close((Closeable)this.transaction);
                    }
                    if (!isBatch) {
                        IoUtil.close(preparedStatement);
                    }
                    throw throwable2;
                }
            }
            IoUtil.close((Closeable)this.transaction);
        }
        if (!isBatch) {
            IoUtil.close((AutoCloseable)preparedStatement);
        }
        if (this.config.isLogSql()) {
            log.info(SqlLoggerUtils.logSql(timer, options.getSql(), options.getParams()));
        }
        return result;
    }

    static class PrepareSql {
        private String sql;
        private List<QueryValParam> params;

        public String getSql() {
            return this.sql;
        }

        public List<QueryValParam> getParams() {
            return this.params;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setParams(List<QueryValParam> params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrepareSql)) {
                return false;
            }
            PrepareSql other = (PrepareSql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            List<QueryValParam> this$params = this.getParams();
            List<QueryValParam> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrepareSql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            List<QueryValParam> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultNbExecutor.PrepareSql(sql=" + this.getSql() + ", params=" + this.getParams() + ")";
        }

        public PrepareSql(String sql, List<QueryValParam> params) {
            this.sql = sql;
            this.params = params;
        }
    }
}

