/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.core.components.builder.INbFieldBuilder;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.PageInfo;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.querier.UpdateData;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.enums.SqlKeyword;
import cn.hperfect.nbquerier.enums.perm.PermType;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlBuilder
implements INbSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultSqlBuilder.class);
    private final INbFieldBuilder fieldBuilder;
    private final IDialectWare dialectWare;

    public DefaultSqlBuilder(IDialectWare dialectWare, INbFieldBuilder fieldBuilder) {
        this.fieldBuilder = fieldBuilder;
        this.dialectWare = dialectWare;
    }

    @Override
    public String buildDeleteSql(NbQuerier<?> querier) {
        Assert.isTrue((boolean)querier.hasWhere(), (String)"\u8be5\u5220\u9664\u8bed\u53e5\u6ca1\u6709\u6761\u4ef6", (Object[])new Object[0]);
        NbQueryInfo queryInfo = querier.getQueryInfo();
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE");
        builder.append(" ");
        builder.append("FROM");
        builder.append(" ");
        builder.append(this.buildFormSql(queryInfo));
        this.appendWhere(querier, queryInfo, builder, true);
        return builder.toString();
    }

    @Override
    public <T> String buildQuerySql(NbQuerier<T> querier, String field, boolean page) {
        NbQueryInfo queryInfo = querier.getQueryInfo();
        if (StrUtil.isBlank((CharSequence)field)) {
            field = this.fieldBuilder.buildFieldSql(querier);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ");
        builder.append(field);
        builder.append(" ");
        builder.append("FROM");
        builder.append(" ");
        builder.append(this.buildFormSql(queryInfo));
        if (CollUtil.isNotEmpty(querier.getJoins())) {
            querier.getJoins().forEach(joinTable -> {
                builder.append(" ");
                builder.append(joinTable.getSqlSegment());
                builder.append(" ");
                builder.append(this.buildFormSql(joinTable.getQueryInfo()));
                builder.append(" ");
                builder.append(SqlKeyword.ON);
                builder.append(" ");
                builder.append(joinTable.getOn());
            });
        }
        this.appendWhere(querier, queryInfo, builder, page);
        if (CollUtil.isNotEmpty(queryInfo.getUnionAllQueries())) {
            for (NbQuerier<?> unionAllQuery : queryInfo.getUnionAllQueries()) {
                builder.append(" ");
                builder.append(SqlKeyword.UNION_ALL);
                builder.append(" ");
                builder.append(this.buildQuerySql(unionAllQuery));
            }
        }
        return builder.toString();
    }

    @Override
    public String buildSaveSql(NbQuerier<?> querier, Map<String, Object> data) {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        NbQueryInfo queryInfo = querier.getQueryInfo();
        Assert.isFalse((boolean)queryInfo.isSub(), (String)"\u5b50\u67e5\u8be2\u4e0d\u652f\u6301\u4fdd\u5b58", (Object[])new Object[0]);
        String table = queryInfo.getTableName();
        INbField orderField = queryInfo.getTable().getOrderField();
        if (queryInfo.getPermType() == PermType.SELF && !queryInfo.isIgnoreDataScope()) {
            INbField one = queryInfo.getPermField();
            Assert.notNull((Object)one, (String)"\u79c1\u6709\u8868:{},\u6ca1\u6709\u6743\u9650\u5b57\u6bb5", (Object[])new Object[]{queryInfo.getTableName()});
            Object permValue = queryInfo.getPermValue();
            Assert.notNull((Object)permValue, (String)"\u79c1\u6709\u8868:{},\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Object userPermVal = data.get(one.getName());
            if (userPermVal == null) {
                data.put(one.getName(), permValue);
            } else {
                Assert.isTrue((boolean)permValue.equals(userPermVal), (String)"\u60a8\u65e0\u6743\u9650\u64cd\u4f5c\u8be5\u6570\u636e", (Object[])new Object[0]);
            }
        }
        data.forEach((key, value) -> {
            INbField one = (INbField)CollUtil.findOne(queryInfo.getFields(), i -> key.equals(i.getName()));
            if (one != null && !one.isSave()) {
                return;
            }
            if (one != null && StrUtil.isNotBlank((CharSequence)one.getTableName()) && !StrUtil.equals((CharSequence)one.getTableName(), (CharSequence)table)) {
                return;
            }
            QueryField queryField = querier.findQueryField((String)key, table);
            boolean isOrder = queryField != null && orderField != null && orderField.getName().equals(queryField.getName());
            boolean insertDefault = one != null && one.isInsertDefault() || isOrder;
            String dbName = Optional.ofNullable(queryField).map(i -> {
                if (StrUtil.isNotBlank((CharSequence)i.getRedirect())) {
                    return i.getRedirect();
                }
                return null;
            }).orElse((String)key);
            if (StrUtil.isBlankIfStr((Object)value) && insertDefault) {
                keys.add(this.dialectWare.quotSqlKey(dbName));
                values.add("default");
            } else if (value != null && queryField != null) {
                keys.add(this.dialectWare.quotSqlKey(dbName));
                values.add(querier.formatVariable(queryField.getType(), value, true));
            }
        });
        Assert.notNull(keys, (String)"\u4fdd\u5b58\u5b57\u6bb5\u4e3a\u7a7a", (Object[])new Object[0]);
        String keySql = String.join((CharSequence)",", keys);
        String valueSql = String.join((CharSequence)",", values);
        return String.format("INSERT INTO %s (%s) VALUES (%s)", queryInfo.getSchemaTable(true), keySql, valueSql);
    }

    @Override
    public String buildSaveSql(NbQuerier<?> querier, List<Map<String, Object>> maps) {
        ArrayList<String> values = new ArrayList<String>();
        NbQueryInfo queryInfo = querier.getQueryInfo();
        Set keys = queryInfo.getFields().stream().filter(INbField::isSave).filter(i -> StrUtil.isBlank((CharSequence)i.getTableName()) || ObjectUtil.equal((Object)i.getTableName(), (Object)querier.getTableName())).map(INbField::getRedirectOrName).collect(Collectors.toSet());
        Assert.notEmpty(keys, (String)"\u6ca1\u6709\u66f4\u65b0\u5b57\u6bb5", (Object[])new Object[0]);
        String tableName = queryInfo.getTableName();
        INbField orderField = queryInfo.getTable().getOrderField();
        for (Map<String, Object> datum : maps) {
            ArrayList<String> oneValue = new ArrayList<String>();
            for (String key : keys) {
                QueryField queryField = querier.findQueryField(key, tableName);
                Assert.notNull((Object)queryField, (String)String.format("table:%s,\u5b57\u6bb5%s\u4e0d\u5b58\u5728", tableName, key), (Object[])new Object[0]);
                Object value = datum.get(key);
                if (StrUtil.isBlankIfStr((Object)value) && orderField != null && orderField.getName().equals(queryField.getName())) {
                    oneValue.add("default");
                    continue;
                }
                oneValue.add(querier.formatVariable(queryField.getType(), value, true));
            }
            values.add(String.format("(%s)", String.join((CharSequence)",", oneValue)));
        }
        String keySql = String.join((CharSequence)",", keys);
        String valueSql = String.join((CharSequence)",", values);
        return StrUtil.format((CharSequence)"INSERT INTO {} ({}) VALUES {}", (Object[])new Object[]{queryInfo.getSchemaTable(true), keySql, valueSql});
    }

    @Override
    public String buildUpdateSql(NbQuerier<?> querier, UpdateData updateData) {
        Assert.notNull((Object)updateData, (String)"\u6ca1\u6709\u66f4\u65b0\u6570\u636e", (Object[])new Object[0]);
        Assert.isTrue((boolean)querier.hasWhere(), (String)"\u8be5\u66f4\u65b0\u8bed\u53e5\u6ca1\u6709\u6761\u4ef6", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        NbQueryInfo queryInfo = querier.getQueryInfo();
        String schemaTable = queryInfo.getSchemaTable(true);
        if (StrUtil.isNotBlank((CharSequence)queryInfo.getAlias())) {
            schemaTable = schemaTable + " " + queryInfo.getAlias();
        }
        builder.append(String.format("UPDATE %s SET ", schemaTable));
        ArrayList<String> setStrings = new ArrayList<String>();
        Map<INbField, Object> updateDataMap = updateData.getUpdateDataMap();
        updateDataMap.forEach((field, value) -> {
            if (field.isPk()) {
                return;
            }
            QueryField queryField = querier.findQueryField(field.getName(), queryInfo.getTableName());
            if (queryField == null) {
                return;
            }
            String key = StrUtil.blankToDefault((CharSequence)queryField.getRedirect(), (String)field.getName());
            String valueParam = querier.formatVariable(field.getQueryType(), value, true);
            setStrings.add(StrUtil.format((CharSequence)"{}={}", (Object[])new Object[]{this.dialectWare.quotSqlKey(key), valueParam}));
        });
        List<String> updateExprList = updateData.getUpdateExprList();
        if (CollUtil.isNotEmpty(updateExprList)) {
            setStrings.addAll(updateExprList);
        }
        Assert.notEmpty(setStrings, (String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e", (Object[])new Object[0]);
        builder.append(String.join((CharSequence)",", setStrings));
        this.appendWhere(querier, queryInfo, builder, true);
        return builder.toString();
    }

    @Override
    public String buildFuncSql(NbQuerier<?> querier, String funcName, boolean limit) {
        return this.buildQuerySql(querier, funcName, limit);
    }

    private void appendWhere(NbQuerier<?> querier, NbQueryInfo queryInfo, StringBuilder builder, boolean page) {
        PageInfo pageInfo;
        Assert.isFalse((!page && querier.getQueryInfo().getPageInfo() != null && querier.getQueryInfo().getPageInfo().isBuild() ? 1 : 0) != 0, (String)"\u4e0d\u67e5\u8be2page\u4fe1\u606f,\u4f46\u662f\u5df2\u7ecf\u67e5\u8be2\u8fc7\u4e86page\u4fe1\u606f\uff0c\u8bf7\u8c03\u6574\u4f4d\u7f6e", (Object[])new Object[0]);
        if (page && queryInfo.getPageInfo() != null && !(pageInfo = queryInfo.getPageInfo()).isBuild()) {
            querier.limit((pageInfo.getPageNo() - 1) * pageInfo.getPageSize(), pageInfo.getPageSize());
            pageInfo.setBuild(true);
        }
        this.buildDataScope(querier, queryInfo);
        this.buildDelete(querier, queryInfo);
        String sqlSegment = querier.getSqlSegment();
        if (querier.hasWhere()) {
            builder.append(" ");
            builder.append("WHERE");
            builder.append(" ");
        }
        builder.append(sqlSegment);
    }

    private void buildDataScope(NbQuerier<?> querier, NbQueryInfo queryInfo) {
        INbField permField;
        if (queryInfo.isIgnoreDataScope() || queryInfo.isBuildDataScope()) {
            return;
        }
        List<Object> dataScope = queryInfo.getDataScope();
        Object permValue = queryInfo.getPermValue();
        PermType permType = querier.getQueryInfo().getPermType();
        if (permType != null && permType != PermType.ALL) {
            switch (permType) {
                case SELF: {
                    Assert.notNull((Object)permValue, (String)"\u79c1\u6709\u8868:{},\u6743\u9650\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{queryInfo.getTableName()});
                    break;
                }
                case AUTHORISED: {
                    Assert.isTrue((boolean)CollUtil.isNotEmpty(dataScope), (String)"\u8868:{}\u6570\u636e\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{queryInfo.getTableName()});
                }
            }
        }
        if (CollUtil.isNotEmpty(dataScope)) {
            permField = queryInfo.getPermField();
            this.setPermValue(querier, queryInfo, dataScope, permField);
        }
        if (permValue != null && permType != PermType.ALL) {
            permField = queryInfo.getPermField();
            this.setPermValue(querier, queryInfo, permValue, permField);
        }
        queryInfo.setBuildDataScope(true);
    }

    private void setPermValue(NbQuerier<?> querier, NbQueryInfo queryInfo, Object permValue, INbField permField) {
        if (permField == null && queryInfo.getPermType() == PermType.ALL) {
            return;
        }
        Assert.notNull((Object)permField, (String)"\u6743\u9650\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String aField = SqlUtils.withAlias((String)querier.getTableAliasMap().get((Object)queryInfo.getTableName()), permField.getName());
        if (permField.getQueryType().isArray()) {
            throw new NbSQLMessageException("\u4e3a\u5b9e\u73b0\u6570\u7ec4\u6570\u636e\u6743\u9650", new Object[0]);
        }
        if (permValue instanceof List) {
            List permValueList = (List)permValue;
            if (permValueList.size() == 1) {
                querier.where(aField, permValueList.get(0));
            } else {
                querier.whereIn(aField, permValueList);
            }
        } else {
            querier.where(aField, permValue);
        }
    }

    private void buildDelete(NbQuerier<?> querier, NbQueryInfo queryInfo) {
        if (queryInfo.getQueryType() != null && queryInfo.getQueryType() == QueryType.FORM_QUERY) {
            return;
        }
        INbField deleteField = queryInfo.getDeleteField();
        if (!queryInfo.isWithDelete() && !queryInfo.isBuildDelete() && deleteField != null) {
            querier.whereNull(SqlUtils.withAlias(queryInfo.getAlias(), deleteField.getName()));
            queryInfo.setBuildDelete(true);
        }
    }

    public String buildFormSql(NbQueryInfo info) {
        StringBuilder stringBuilder = new StringBuilder();
        if (info.isSub()) {
            stringBuilder.append("(");
            stringBuilder.append(info.getSql());
            stringBuilder.append(")");
        } else if (info.getQueryType() != null && info.getQueryType() == QueryType.FORM_QUERY) {
            stringBuilder.append("(");
            stringBuilder.append(this.buildQuerySql(info.getFromQuerier()));
            stringBuilder.append(")");
        } else {
            stringBuilder.append(SqlUtils.withAlias(info.getSchema(), info.getTableName()));
        }
        String alias = info.getAlias();
        if (StrUtil.isNotBlank((CharSequence)alias)) {
            stringBuilder.append(" ");
            stringBuilder.append(alias);
        }
        return stringBuilder.toString();
    }
}

