/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.core.components.builder.INbFieldBuilder;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.ConditionAgg;
import cn.hperfect.nbquerier.core.metedata.JoinTableRule;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.QueryFields;
import cn.hperfect.nbquerier.core.metedata.QueryItem;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.table.VirtualTable;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.toolkit.BuildUtils;
import cn.hperfect.nbquerier.toolkit.FieldParseUtils;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFieldBuilder
implements INbFieldBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultFieldBuilder.class);
    final IDialectWare dialectWare;
    private final List<String> ignoreBuild = ListUtil.toList((Object[])new String[]{"*", "1"});

    public DefaultFieldBuilder(IDialectWare dialectWare) {
        this.dialectWare = dialectWare;
    }

    @Override
    public <T> String buildFieldSql(NbQuerier<T> querier) {
        List<String> additionFields;
        BiMap<String, String> tableAliasMap = querier.getTableAliasMap();
        NbQueryInfo queryInfo = querier.getQueryInfo();
        Collection<QueryField> fields = querier.getQueryFields().fields();
        List<JoinTableRule> joins = querier.getJoins();
        List<ConditionAgg> conditionAggList = querier.getConditionAggList();
        String setField = queryInfo.getSetField();
        ArrayList<String> selectFields = new ArrayList<String>();
        ArrayList<QueryItem> queryItemList = new ArrayList<QueryItem>();
        boolean isExclude = true;
        if (StrUtil.isNotBlank((CharSequence)setField)) {
            if (CollUtil.contains(this.ignoreBuild, (Object)setField)) {
                return setField;
            }
            isExclude = StrUtil.startWith((CharSequence)setField, (CharSequence)"!");
            if (isExclude) {
                setField = StrUtil.removePrefix((CharSequence)setField, (CharSequence)"!");
            }
            List<QueryItem> items = FieldParseUtils.simpleParse(setField);
            for (QueryItem item : items) {
                if (item.isFunc()) continue;
                item.setName(StrUtil.toUnderlineCase((CharSequence)item.getName()));
            }
            queryItemList.addAll(items);
        }
        if (!"".equals(setField)) {
            if (isExclude) {
                selectFields.addAll(this.allExclude(tableAliasMap, queryInfo, joins, queryItemList));
            } else {
                selectFields.addAll(this.pointField(tableAliasMap, queryInfo, fields, queryItemList));
            }
        }
        if (CollUtil.isNotEmpty(additionFields = queryInfo.getAdditionFields())) {
            selectFields.addAll(additionFields);
        }
        if (CollUtil.isNotEmpty(conditionAggList)) {
            selectFields.addAll(this.buildConditionAggList(conditionAggList));
        }
        String queryField = String.join((CharSequence)",", selectFields);
        Assert.notBlank((CharSequence)queryField, () -> new NbSQLMessageException("\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        return queryField;
    }

    private List<String> buildConditionAggList(List<? extends ConditionAgg> conditionAggList) {
        return conditionAggList.stream().map(ConditionAgg::getSqlSegment).collect(Collectors.toList());
    }

    private List<String> allExclude(BiMap<String, String> tableAliasMap, NbQueryInfo queryInfo, List<JoinTableRule> joins, List<QueryItem> excludeList) {
        ArrayList<String> selectFields = new ArrayList<String>();
        for (INbField field : CollUtil.filterNew(queryInfo.getFields(), INbField::isQuery)) {
            String addSelectField = this.parseAddField(tableAliasMap, queryInfo, joins, excludeList, field);
            if (!StrUtil.isNotBlank((CharSequence)addSelectField)) continue;
            selectFields.add(addSelectField);
        }
        return selectFields;
    }

    private String parseAddField(BiMap<String, String> tableAliasMap, NbQueryInfo queryInfo, List<JoinTableRule> joins, List<QueryItem> excludeList, INbField field) {
        boolean isInThisTable;
        String fieldTable = field.getTableName();
        QueryItem exclude = (QueryItem)CollUtil.findOne(excludeList, i -> i.getName().equals(field.getName()));
        String addSelectField = null;
        boolean bl = isInThisTable = StrUtil.isNotBlank((CharSequence)fieldTable) && !fieldTable.equals(queryInfo.getTableName());
        if (isInThisTable) {
            boolean contains;
            if (CollUtil.isNotEmpty(joins) && (contains = CollUtil.contains(joins, i -> {
                String queryTable;
                NbQueryInfo joinQueryInfo = i.getQueryInfo();
                if (joinQueryInfo.getQueryType() == QueryType.SUB) {
                    VirtualTable virtualTable = joinQueryInfo.getVirtualTable();
                    queryTable = virtualTable.getMasterTable();
                } else {
                    queryTable = joinQueryInfo.getTableName();
                }
                Assert.notBlank((CharSequence)queryTable, () -> new NbSQLMessageException("\u8fde\u8868\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
                return ObjectUtil.equal((Object)queryTable, (Object)fieldTable);
            }))) {
                String tableName = fieldTable;
                addSelectField = this.isAddSelectField(tableAliasMap, tableName, exclude, field);
            }
        } else {
            String tableName = queryInfo.getTableName();
            addSelectField = this.isAddSelectField(tableAliasMap, tableName, exclude, field);
        }
        return addSelectField;
    }

    public String isAddSelectField(BiMap<String, String> tableAliasMap, String tableName, QueryItem exclude, INbField field) {
        String fieldName = field.getName();
        String alias = (String)tableAliasMap.get((Object)tableName);
        if (exclude != null && exclude.getName().equals(fieldName)) {
            if (StrUtil.isBlank((CharSequence)exclude.getTableAlias()) || MapUtil.isEmpty(tableAliasMap)) {
                return null;
            }
            if (exclude.getTableAlias().equals(alias)) {
                return null;
            }
            if (exclude.getTableAlias().equals(tableName)) {
                return null;
            }
        }
        String quotSqlKey = this.dialectWare.quotSqlKey(fieldName);
        String queryName = field.getQueryType() == NbQueryType.FUNC ? quotSqlKey : SqlUtils.withAlias(alias, quotSqlKey);
        String fieldAlias = field.getAlias();
        if (StrUtil.isNotBlank((CharSequence)fieldAlias)) {
            queryName = queryName + " AS " + fieldAlias;
        }
        return queryName;
    }

    private List<String> pointField(BiMap<String, String> tableAliasMap, NbQueryInfo queryInfo, Collection<QueryField> fields, List<QueryItem> pointList) {
        ArrayList<String> queryItemList = new ArrayList<String>();
        for (QueryItem pointField : pointList) {
            if (pointField.isFunc()) {
                queryItemList.add(pointField.getExpr());
                continue;
            }
            if ("*".equals(pointField.getName())) {
                if (queryInfo.isFieldReplace()) {
                    queryItemList.add(pointField.getExpr());
                    break;
                }
                String table = BuildUtils.getTableByField(pointField, tableAliasMap);
                Collection queryFields = CollUtil.filterNew(fields, i -> i.getTableName().equals(table));
                for (QueryField queryField : queryFields) {
                    queryItemList.add(SqlUtils.withAlias(pointField.getTableAlias(), queryField.getName()));
                }
                break;
            }
            if (StrUtil.isBlank((CharSequence)pointField.getTableAlias())) {
                QueryField one = BuildUtils.findOne(new QueryFields(fields), pointField, queryInfo.getTableName(), tableAliasMap);
                Assert.notNull((Object)one, (String)"\u67e5\u8be2\u5b57\u6bb5:{}\u4e3a\u7a7a", (Object[])new Object[]{pointField.getName()});
                String tableAlias = (String)tableAliasMap.get((Object)one.getTableName());
                queryItemList.add(pointField.getExpr(tableAlias));
                continue;
            }
            queryItemList.add(pointField.getExpr());
        }
        return queryItemList;
    }

    @Deprecated
    public static List<String> parseField(String str) {
        String sql = StrUtil.format((CharSequence)"select {} from a", (Object[])new Object[]{str});
        final ArrayList<String> fields = new ArrayList<String>();
        Select select = null;
        try {
            select = (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            log.error("\u5b57\u6bb5\u89e3\u6790\u5931\u8d25:", (Throwable)e);
            throw new NbSQLMessageException("\u5b57\u6bb5\u89e3\u6790\u5931\u8d25", new Object[0]);
        }
        SelectBody selectBody = select.getSelectBody();
        selectBody.accept(new SelectVisitor(){

            public void visit(PlainSelect plainSelect) {
                List selectItems = plainSelect.getSelectItems();
                selectItems.forEach(i -> fields.add(i.toString()));
            }

            public void visit(SetOperationList setOperationList) {
            }

            public void visit(WithItem withItem) {
            }

            public void visit(ValuesStatement valuesStatement) {
            }
        });
        return fields;
    }
}

