/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.executor.DefaultNbExecutor;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.result.IResultSetHandler;
import cn.hperfect.nbquerier.core.components.result.json.HutoolJsonSerializer;
import cn.hperfect.nbquerier.core.components.result.json.NbJsonSerializer;
import cn.hperfect.nbquerier.core.components.route.ISchemaRoute;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hperfect.nbquerier.core.transaction.TransactionIsolationLevel;
import cn.hperfect.nbquerier.session.ISqlMapperBuilder;
import java.sql.Connection;

public class NbQuerierConfiguration {
    private final NbQuerierProperties config;
    private ValidatorRegistry validatorRegistry;
    private NbInterceptorRegistry nbInterceptorRegistry;
    private FieldFillStrategyRegistry fieldFillStrategyRegistry;
    private INbQueryBuilder nbQueryBuilder;
    private INbSqlBuilder nbSqlBuilder;
    private IResultSetHandler resultSetHandler;
    private INbDataSource nbDataSource;
    private IDialectWare dialectWare;
    private ISchemaRoute schemaRoute;
    private ISqlMapperBuilder sqlMapperBuilder;
    private ITransactionFactory transactionFactory;
    private NbJsonSerializer jsonSerializer = new HutoolJsonSerializer();

    public NbQuerierConfiguration(NbQuerierProperties config) {
        this.config = config;
    }

    public INbExecutor newNbExecutor(Connection conn) {
        return this.newNbExecutor(this.newTx(conn));
    }

    public INbExecutor newNbExecutor() {
        INbTransaction tx = this.newTx();
        return this.newNbExecutor(tx);
    }

    public INbTransaction newTx(Connection conn) {
        return this.transactionFactory.newTransaction(conn);
    }

    public INbTransaction newTx() {
        return this.transactionFactory.newTransaction(this.nbDataSource, TransactionIsolationLevel.NONE, false);
    }

    public INbExecutor newNbExecutor(INbTransaction tx) {
        return new DefaultNbExecutor(tx, this.config, this.nbSqlBuilder, this.resultSetHandler, this.jsonSerializer);
    }

    public NbQuerierProperties getConfig() {
        return this.config;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    public NbInterceptorRegistry getNbInterceptorRegistry() {
        return this.nbInterceptorRegistry;
    }

    public FieldFillStrategyRegistry getFieldFillStrategyRegistry() {
        return this.fieldFillStrategyRegistry;
    }

    public INbQueryBuilder getNbQueryBuilder() {
        return this.nbQueryBuilder;
    }

    public INbSqlBuilder getNbSqlBuilder() {
        return this.nbSqlBuilder;
    }

    public IResultSetHandler getResultSetHandler() {
        return this.resultSetHandler;
    }

    public INbDataSource getNbDataSource() {
        return this.nbDataSource;
    }

    public IDialectWare getDialectWare() {
        return this.dialectWare;
    }

    public ISchemaRoute getSchemaRoute() {
        return this.schemaRoute;
    }

    public ISqlMapperBuilder getSqlMapperBuilder() {
        return this.sqlMapperBuilder;
    }

    public ITransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public NbJsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.validatorRegistry = validatorRegistry;
    }

    public void setNbInterceptorRegistry(NbInterceptorRegistry nbInterceptorRegistry) {
        this.nbInterceptorRegistry = nbInterceptorRegistry;
    }

    public void setFieldFillStrategyRegistry(FieldFillStrategyRegistry fieldFillStrategyRegistry) {
        this.fieldFillStrategyRegistry = fieldFillStrategyRegistry;
    }

    public void setNbQueryBuilder(INbQueryBuilder nbQueryBuilder) {
        this.nbQueryBuilder = nbQueryBuilder;
    }

    public void setNbSqlBuilder(INbSqlBuilder nbSqlBuilder) {
        this.nbSqlBuilder = nbSqlBuilder;
    }

    public void setResultSetHandler(IResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    public void setNbDataSource(INbDataSource nbDataSource) {
        this.nbDataSource = nbDataSource;
    }

    public void setDialectWare(IDialectWare dialectWare) {
        this.dialectWare = dialectWare;
    }

    public void setSchemaRoute(ISchemaRoute schemaRoute) {
        this.schemaRoute = schemaRoute;
    }

    public void setSqlMapperBuilder(ISqlMapperBuilder sqlMapperBuilder) {
        this.sqlMapperBuilder = sqlMapperBuilder;
    }

    public void setTransactionFactory(ITransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setJsonSerializer(NbJsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }
}

