/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.config;

import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultFieldBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultNbQueryBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.DefaultSqlBuilder;
import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.components.dialect.DefaultDialectWare;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl.NotNullValidator;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl.UniqueValidator;
import cn.hperfect.nbquerier.core.components.interceptor.impl.ConstraintInterceptor;
import cn.hperfect.nbquerier.core.components.interceptor.impl.FillInterceptor;
import cn.hperfect.nbquerier.core.components.result.DefaultResultSetHandler;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hutool.core.lang.Assert;

public enum NbQuerierConfigFactory {
    INSTANCE;

    private NbQuerierConfiguration configuration;

    public NbQuerierConfiguration getConfiguration() {
        Assert.notNull((Object)this.configuration, (String)"\u672a\u521d\u59cb\u5316\u914d\u7f6e,\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5", (Object[])new Object[0]);
        return this.configuration;
    }

    public NbQuerierConfiguration init(NbQuerierProperties config, ITransactionFactory transactionFactory, INbDataSource dataSource) {
        this.configuration = new NbQuerierConfiguration(config);
        this.configuration.setNbDataSource(dataSource);
        this.configuration.setTransactionFactory(transactionFactory);
        DefaultDialectWare dialectWare = new DefaultDialectWare(config);
        this.configuration.setDialectWare(dialectWare);
        this.configuration.setValidatorRegistry(this.newValidatorRegistry());
        this.configuration.setNbInterceptorRegistry(NbQuerierConfigFactory.newInterceptorRegistry());
        this.configuration.setFieldFillStrategyRegistry(new FieldFillStrategyRegistry());
        this.configuration.setResultSetHandler(new DefaultResultSetHandler(config));
        this.configuration.setNbQueryBuilder(this.newNbQueryBuilder());
        this.configuration.setNbSqlBuilder(this.newNbSqlBuilder(dialectWare));
        return this.configuration;
    }

    private static NbInterceptorRegistry newInterceptorRegistry() {
        NbInterceptorRegistry nbInterceptorRegistry = new NbInterceptorRegistry();
        nbInterceptorRegistry.addInterceptor(new FillInterceptor());
        nbInterceptorRegistry.addInterceptor(new ConstraintInterceptor());
        return nbInterceptorRegistry;
    }

    private INbSqlBuilder newNbSqlBuilder(IDialectWare dialectWare) {
        DefaultFieldBuilder fieldBuilder = new DefaultFieldBuilder(dialectWare);
        return new DefaultSqlBuilder(dialectWare, fieldBuilder);
    }

    public DefaultNbQueryBuilder newNbQueryBuilder() {
        return new DefaultNbQueryBuilder(this.configuration);
    }

    public ValidatorRegistry newValidatorRegistry() {
        ValidatorRegistry validatorRegistry = new ValidatorRegistry();
        validatorRegistry.put(new NotNullValidator());
        validatorRegistry.put(UniqueValidator.INSTANCE);
        return validatorRegistry;
    }

    public void setConfiguration(NbQuerierConfiguration configuration) {
        this.configuration = configuration;
    }
}

