/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.util.List;

public class SqlLoggerUtils {
    public static StringBuilder loggerStart() {
        StringBuilder logger = new StringBuilder();
        logger.append("\n-----------").append("sql-start").append("----------\n");
        return logger;
    }

    public static String logSql(TimeInterval timer, String sql, List<QueryValParam> params) {
        StringBuilder logger = SqlLoggerUtils.loggerStart();
        logger.append(SqlLoggerUtils.logSql(sql, params));
        SqlLoggerUtils.logEnd(logger, timer);
        return logger.toString();
    }

    public static String logSql(String sql, List<QueryValParam> params) {
        String logSql = sql;
        if (CollUtil.isNotEmpty(params)) {
            List all = ReUtil.findAll((String)"#\\{NB_PARAM_(\\d+)\\}", (CharSequence)sql, (int)0);
            for (int i = 0; i < all.size(); ++i) {
                String paramStr = (String)all.get(i);
                String indexStr = ReUtil.get((String)"#\\{NB_PARAM_(\\d+)\\}", (CharSequence)paramStr, (int)1);
                Assert.notBlank((CharSequence)indexStr, (String)"\u53c2\u6570\u66ff\u6362\u5931\u8d25\uff0c\u5360\u4f4d\u7b26\u4e0d\u5408\u6cd5:{}", (Object[])new Object[]{indexStr});
                QueryValParam param = params.get(Convert.toInt((Object)indexStr));
                logSql = StrUtil.replace((CharSequence)logSql, (CharSequence)paramStr, (CharSequence)SqlLoggerUtils.getLogValueSql(param.getType(), param.getValue()));
            }
        }
        if (CollUtil.isNotEmpty(params)) {
            for (QueryValParam param : params) {
                logSql = logSql.replaceFirst("\\?", SqlLoggerUtils.getLogValueSql(param.getType(), param.getValue()));
            }
        }
        return logSql;
    }

    private static String getLogValueSql(INbQueryType type, Object value) {
        Object convertValue;
        if (value == null) {
            return "null";
        }
        if (type == NbQueryType.TEXT || type == NbQueryType.DATE) {
            return StrUtil.format((CharSequence)"'{}'", (Object[])new Object[]{value});
        }
        if (type == NbQueryType.MAP_ENUM) {
            Object convert = NbQueryType.MAP_ENUM.getConvert().convert(value);
            if (convert != null) {
                if (convert instanceof String) {
                    return StrUtil.format((CharSequence)"'{}'", (Object[])new Object[]{convert});
                }
                return convert.toString();
            }
        } else if (type.isJson()) {
            return JSONUtil.toJsonStr((Object)value);
        }
        if ((convertValue = type.convert(value)) == null) {
            return "null";
        }
        if (type.isArray()) {
            String valueStr = StrUtil.join((CharSequence)",", (Object[])new Object[]{convertValue});
            return StrUtil.format((CharSequence)"array [{}]::{}", (Object[])new Object[]{valueStr, type.getDbTypeSql()});
        }
        return convertValue.toString();
    }

    public static void logEnd(StringBuilder logger, TimeInterval timer) {
        logger.append("\n----------").append("-sql-end------------").append(StrUtil.format((CharSequence)"\u8017\u65f6:{}ms", (Object[])new Object[]{timer.intervalMs()}));
    }
}

