/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.QueryFields;
import cn.hperfect.nbquerier.core.metedata.QueryItem;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BuildUtils {
    private BuildUtils() {
    }

    public static String getTableByField(QueryItem item, BiMap<String, String> tableAliasMap) {
        String fieldTableAlias = item.getTableAlias();
        String table = null;
        if (fieldTableAlias == null) {
            return null;
        }
        if (tableAliasMap.containsValue((Object)item.getTableAlias())) {
            table = (String)tableAliasMap.getKey((Object)item.getTableAlias());
        } else if (tableAliasMap.containsKey((Object)fieldTableAlias)) {
            table = fieldTableAlias;
        }
        Assert.notBlank((CharSequence)table, () -> new NbSQLMessageException("\u5b57\u6bb5:{},\u8868\u522b\u540d\u4e3a{}\u7684\u8868\u4e0d\u5b58\u5728", item.getName(), fieldTableAlias));
        return table;
    }

    public static Collection<QueryField> find(QueryFields fields, String fieldName, String table) {
        Collection queryFields = fields.findByName(fieldName);
        if (CollUtil.size(queryFields) > 1 && StrUtil.isNotBlank((CharSequence)table)) {
            queryFields = CollUtil.filterNew(queryFields, k -> table.equals(k.getTableName()));
        }
        return queryFields;
    }

    public static QueryField findOne(QueryFields fields, QueryItem item, String masterTable, BiMap<String, String> tableAliasMap) {
        String fieldTable = BuildUtils.getTableByField(item, tableAliasMap);
        Collection<QueryField> fieldList = BuildUtils.find(fields, item.getName(), fieldTable);
        Assert.notEmpty(fieldList, () -> new NbSQLMessageException("\u67e5\u8be2\u8868\u5355:{},\u5b57\u6bb5:{}\u4e0d\u5b58\u5728", ObjectUtil.defaultIfBlank((CharSequence)fieldTable, (CharSequence)masterTable), item.getName()));
        if (fieldList.size() > 1) {
            if (fieldTable == null && StrUtil.isNotBlank((CharSequence)masterTable)) {
                return (QueryField)CollUtil.findOne(fieldList, i -> StrUtil.equals((CharSequence)masterTable, (CharSequence)i.getTableName()));
            }
            List tables = fieldList.stream().map(QueryField::getTableName).collect(Collectors.toList());
            throw new NbSQLMessageException("\u5b57\u6bb5:{},\u5728\u8868:{},\u4e2d\u90fd\u5b58\u5728,\u8bf7\u6307\u5b9a\u8868\u540d", item.getName(), tables);
        }
        return (QueryField)fieldList.stream().iterator().next();
    }
}

