/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.type;

import cn.hperfect.nbquerier.annotation.NbExcel;
import cn.hperfect.nbquerier.annotation.NbJsonProp;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.metedata.JsonPropMeteData;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.type.JsonPropVO;
import cn.hperfect.nbquerier.enums.DbDataType;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;
import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.lang.Nullable;

public class JsonNbType
implements INbQueryType {
    @Nullable
    protected Boolean jsonArray;
    protected List<JsonPropMeteData> props;
    public static final List<QueryRuleEnum> rules = ListUtil.toList((Object[])new QueryRuleEnum[]{QueryRuleEnum.EMPTY, QueryRuleEnum.LIKE, QueryRuleEnum.NOT_EMPTY});
    protected Class<? extends JsonPropVO> voClass;

    public JsonNbType(Boolean jsonArray) {
        this.jsonArray = jsonArray;
        this.props = new ArrayList<JsonPropMeteData>();
    }

    public JsonNbType(boolean isArray, Class<? extends JsonPropVO> clazz) {
        this.jsonArray = isArray;
        this.voClass = clazz;
        BeanDesc beanDesc = BeanUtil.getBeanDesc(clazz);
        this.props = new ArrayList<JsonPropMeteData>();
        for (PropDesc prop : beanDesc.getProps()) {
            NbExcel nbExcel;
            JsonPropMeteData data = new JsonPropMeteData();
            data.setName(prop.getFieldName());
            Field field = prop.getField();
            INbQueryType queryType = NbQueryType.convertFromClass(field.getType(), field.getGenericType());
            data.setQueryType(queryType);
            NbJsonProp nbJsonProp = prop.getField().getAnnotation(NbJsonProp.class);
            if (nbJsonProp != null) {
                data.setIndex(nbJsonProp.index());
                data.setTitle(nbJsonProp.title());
            }
            if ((nbExcel = prop.getField().getAnnotation(NbExcel.class)) != null) {
                data.setExcelIgnore(nbExcel.ignore());
            }
            this.props.add(data);
        }
        CollUtil.sort(this.props, Comparator.comparingInt(JsonPropMeteData::getIndex));
    }

    @Override
    public DbDataType getDbDataType() {
        return DbDataType.JSON;
    }

    @Override
    public Object convert(Object value) throws TypeConvertException {
        return value;
    }

    @Override
    public String getDbTypeSql() {
        return "jsonb";
    }

    @Override
    public String getTitle() {
        return "json";
    }

    @Override
    public void whereLike(NbQuerier<?> querier, MergeSegments expression, String name, Object value) {
        this.toStrWhereLike(querier, expression, name, value);
    }

    @Override
    public List<QueryRuleEnum> getQueryRules() {
        return rules;
    }

    @Override
    public boolean orderAble() {
        return false;
    }

    protected final void toStrWhereLike(NbQuerier<?> querier, MergeSegments expression, String name, Object value) {
        assert (value instanceof String) : "\u6a21\u7cca\u67e5\u8be2\u5fc5\u987b\u4f20\u5165\u5b57\u7b26\u4e32";
        String valueStr = (String)value;
        valueStr = StrUtil.removePrefix((CharSequence)valueStr, (CharSequence)"%");
        valueStr = StrUtil.removeSuffix((CharSequence)valueStr, (CharSequence)"%");
        value = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{"%", valueStr, "%"});
        String paramKey = querier.formatVariable(NbQueryType.TEXT, value, false);
        expression.add(() -> name + "::text", QueryRuleEnum.LIKE, () -> paramKey);
    }

    public boolean isJsonArray() {
        return BooleanUtil.isTrue((Boolean)this.jsonArray);
    }

    @Nullable
    public Boolean getJsonArray() {
        return this.jsonArray;
    }

    public List<JsonPropMeteData> getProps() {
        return this.props;
    }

    public Class<? extends JsonPropVO> getVoClass() {
        return this.voClass;
    }

    public void setJsonArray(@Nullable Boolean jsonArray) {
        this.jsonArray = jsonArray;
    }

    public void setProps(List<JsonPropMeteData> props) {
        this.props = props;
    }

    public void setVoClass(Class<? extends JsonPropVO> voClass) {
        this.voClass = voClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNbType)) {
            return false;
        }
        JsonNbType other = (JsonNbType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$jsonArray = this.getJsonArray();
        Boolean other$jsonArray = other.getJsonArray();
        if (this$jsonArray == null ? other$jsonArray != null : !((Object)this$jsonArray).equals(other$jsonArray)) {
            return false;
        }
        List<JsonPropMeteData> this$props = this.getProps();
        List<JsonPropMeteData> other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        Class<? extends JsonPropVO> this$voClass = this.getVoClass();
        Class<? extends JsonPropVO> other$voClass = other.getVoClass();
        return !(this$voClass == null ? other$voClass != null : !this$voClass.equals(other$voClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonNbType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $jsonArray = this.getJsonArray();
        result = result * 59 + ($jsonArray == null ? 43 : ((Object)$jsonArray).hashCode());
        List<JsonPropMeteData> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        Class<? extends JsonPropVO> $voClass = this.getVoClass();
        result = result * 59 + ($voClass == null ? 43 : $voClass.hashCode());
        return result;
    }

    public String toString() {
        return "JsonNbType(jsonArray=" + this.getJsonArray() + ", props=" + this.getProps() + ", voClass=" + this.getVoClass() + ")";
    }

    public JsonNbType() {
    }
}

