/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.transaction.jdbc;

import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.core.transaction.TransactionException;
import cn.hperfect.nbquerier.core.transaction.TransactionIsolationLevel;
import cn.hutool.core.lang.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransaction
implements INbTransaction {
    private static final Logger log = LoggerFactory.getLogger(JdbcTransaction.class);
    protected Connection connection;
    protected DataSource dataSource;
    protected TransactionIsolationLevel level;
    protected boolean autoCommmit;

    public JdbcTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit) {
        this.dataSource = ds;
        this.level = desiredLevel;
        this.autoCommmit = desiredAutoCommit;
    }

    public JdbcTransaction(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection(String dsName) throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.debug("Committing JDBC Connection [" + this.connection + "]");
            }
            this.connection.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.debug("Rolling back JDBC Connection [" + this.connection + "]");
            }
            this.connection.rollback();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public void close() {
    }

    public void close(boolean reallyClose) throws SQLException {
        if (reallyClose && this.connection != null) {
            this.resetAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug("Closing JDBC Connection [" + this.connection + "]");
            }
            this.connection.close();
        }
    }

    protected void setDesiredAutoCommit(boolean desiredAutoCommit) {
        try {
            if (this.connection.getAutoCommit() != desiredAutoCommit) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting autocommit to " + desiredAutoCommit + " on JDBC Connection [" + this.connection + "]");
                }
                this.connection.setAutoCommit(desiredAutoCommit);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Error configuring AutoCommit.  Your driver may not support getAutoCommit() or setAutoCommit(). Requested setting: " + desiredAutoCommit + ".  Cause: " + e, e);
        }
    }

    protected void resetAutoCommit() {
        try {
            if (!this.connection.getAutoCommit()) {
                if (log.isDebugEnabled()) {
                    log.debug("Resetting autocommit to true on JDBC Connection [" + this.connection + "]");
                }
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.debug("Error resetting autocommit to true before closing the connection.  Cause: " + e);
        }
    }

    protected void openConnection() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Opening JDBC Connection");
        }
        this.connection = this.dataSource.getConnection();
        Assert.notNull((Object)this.connection, (String)"\u6570\u636e\u6e90\u6253\u5f00\u8fde\u63a5\u5931\u8d25", (Object[])new Object[0]);
        if (this.level != null) {
            this.connection.setTransactionIsolation(this.level.getLevel());
        }
        this.setDesiredAutoCommit(this.autoCommmit);
    }
}

