/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.querier.qrs;

import cn.hperfect.nbquerier.core.metedata.InputNbTable;
import cn.hperfect.nbquerier.core.metedata.JsonPropMeteData;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.querier.qrs.JsonQueryValue;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueryExprParser {
    INSTANCE;

    private static final Logger log;
    private static final String OPERATOR = "$";
    private static final String OPERATOR_OR = "$or";
    private static final String OPERATOR_AND = "$and";
    private static final String OPERATOR_FIELD = "$field";
    private static final String OPERATOR_TYPE = "$type";
    private static final String OPERATOR_VALUE = "$value";
    private static final String OPERATOR_JSON = "$json";

    public void parseJsonObjectToCondition(NbQuerier<?> query, String queryExpr) {
        JSONObject jsonObject;
        if (StrUtil.isNotEmpty((CharSequence)queryExpr) && (jsonObject = JSONUtil.parseObj((String)queryExpr)).size() > 0) {
            QueryExprParser.parseJsonObjectToCondition(query, jsonObject);
        }
    }

    public static void parseJsonObjectToCondition(NbQuerier<?> query, JSONObject jsonObject) {
        jsonObject.forEach((key, value) -> {
            if (key.startsWith(OPERATOR)) {
                RootOperator rootOperator = RootOperator.convertFromKey(key);
                switch (rootOperator) {
                    case OPERATOR_OR: {
                        if (value instanceof JSONArray) {
                            JSONArray vArray = (JSONArray)value;
                            query.where(i -> {
                                for (Object jsonObj : vArray) {
                                    JSONObject valObj = (JSONObject)jsonObj;
                                    QueryExprParser.parseJsonObjectToCondition(i.or(), valObj);
                                }
                            });
                            break;
                        }
                        query.where(i -> {
                            JSONObject objectOr = (JSONObject)value;
                            objectOr.forEach((k, v) -> {
                                JSONObject val = new JSONObject();
                                val.set(k, v);
                                QueryExprParser.parseJsonObjectToCondition(i.or(), val);
                            });
                        });
                        break;
                    }
                    case OPERATOR_AND: {
                        if (value instanceof JSONArray) {
                            JSONArray vArray = (JSONArray)value;
                            query.where(i -> {
                                for (Object jsonObj : vArray) {
                                    QueryExprParser.parseJsonObjectToCondition(i, (JSONObject)jsonObj);
                                }
                            });
                            break;
                        }
                        query.where(i -> QueryExprParser.parseJsonObjectToCondition(i, (JSONObject)value));
                        break;
                    }
                    case OPERATOR_FIELD: {
                        query.field(value.toString());
                        break;
                    }
                    default: {
                        throw new NbSQLMessageException("\u4e0d\u652f\u6301\u6307\u4ee4\u64cd\u4f5c\u7b26:{}", new Object[]{rootOperator});
                    }
                }
            } else {
                String dbKey = StrUtil.toUnderlineCase((CharSequence)key);
                if (dbKey.contains(OPERATOR)) {
                    List tow = StrUtil.split((CharSequence)dbKey, (CharSequence)OPERATOR);
                    JSONObject obg = new JSONObject();
                    JSONObject obgValue = new JSONObject();
                    obgValue.set(OPERATOR_TYPE, (Object)(OPERATOR + (String)tow.get(1)));
                    obgValue.set(OPERATOR_VALUE, value);
                    obg.set((String)tow.get(0), (Object)obgValue);
                    QueryExprParser.parseJsonObjectToCondition(query, obg);
                    return;
                }
                if (value instanceof JSONNull) {
                    return;
                }
                if (value instanceof JSONObject) {
                    JSONObject conditionValue = (JSONObject)value;
                    if (((JSONObject)value).containsKey((Object)OPERATOR_TYPE)) {
                        String opType = conditionValue.getStr((Object)OPERATOR_TYPE);
                        if (StrUtil.isNotBlank((CharSequence)opType)) {
                            QueryExprParser.parseOperation(query, dbKey, conditionValue.getStr((Object)OPERATOR_TYPE), conditionValue.get((Object)OPERATOR_VALUE));
                        }
                    } else {
                        ((JSONObject)value).forEach((k2, v2) -> {
                            if (k2.startsWith(OPERATOR) && v2 != null) {
                                QueryExprParser.parseOperation(query, dbKey, k2, v2);
                            }
                        });
                    }
                } else if (value instanceof JsonQueryValue) {
                    JsonQueryValue jsonQueryValue = (JsonQueryValue)value;
                    QueryRuleEnum rule = QueryRuleEnum.parse(jsonQueryValue.getType());
                    query.where(jsonQueryValue, rule, jsonQueryValue.getQueryValue(), false);
                } else {
                    query.where(dbKey, QueryRuleEnum.EQ, value);
                }
            }
        });
    }

    private static void parseJsonExpr(NbQuerier<?> query, String field, Object value) {
        Assert.isTrue((value instanceof JSONArray || value instanceof JSONObject ? 1 : 0) != 0, (String)"value \u5fc5\u987b\u4e3a\u6570\u7ec4\u6216\u5bf9\u8c61", (Object[])new Object[0]);
        QueryField queryField = query.findField(field);
        Assert.notNull((Object)queryField, (String)"\u5b57\u6bb5:{}\u4e0d\u5b58\u5728", (Object[])new Object[]{queryField});
        Assert.isTrue((boolean)(queryField.getType() instanceof JsonNbType), (String)"json\u67e5\u8be2\u64cd\u4f5c\u53ea\u652f\u6301json\u5b57\u6bb5", (Object[])new Object[0]);
        JsonNbType jsonType = (JsonNbType)queryField.getType();
        List<JsonPropMeteData> props = ((JsonNbType)queryField.getType()).getProps();
        if (jsonType.isJsonArray()) {
            QueryExprParser.parseJsonArray(query, field, value, jsonType, props);
        } else {
            QueryExprParser.parseJsonObject(query, field, value, jsonType, props);
        }
    }

    private static void parseJsonObject(NbQuerier<?> query, String field, Object value, JsonNbType jsonNbType, List<JsonPropMeteData> props) {
        Assert.isTrue((boolean)(value instanceof JSONObject), (String)"\u6682\u65f6\u53ea\u652f\u6301object", (Object[])new Object[0]);
        JSONObject jsonValue = (JSONObject)value;
        JSONObject newQrs = new JSONObject();
        jsonValue.forEach((k, v) -> {
            String type;
            String propName;
            if (StrUtil.contains((CharSequence)k, (CharSequence)OPERATOR)) {
                List split = StrUtil.split((CharSequence)k, (CharSequence)OPERATOR);
                propName = (String)split.get(0);
                type = (String)split.get(1);
            } else {
                type = "=";
                propName = k;
            }
            JsonPropMeteData one = (JsonPropMeteData)CollUtil.findOne((Iterable)props, i -> i.getName().equals(propName));
            Assert.notNull((Object)one, (String)"\u672a\u627e\u5230json\u5c5e\u6027:{}", (Object[])new Object[]{propName});
            JsonQueryValue jsonQueryValue = new JsonQueryValue();
            jsonQueryValue.setType(type);
            jsonQueryValue.setValue(v);
            jsonQueryValue.setFieldName(field);
            jsonQueryValue.setPropName(propName);
            jsonQueryValue.setQueryType(one.getQueryType());
            newQrs.set(field + "." + propName, (Object)jsonQueryValue);
        });
        QueryExprParser.parseJsonObjectToCondition(query, newQrs);
    }

    private static void parseJsonArray(NbQuerier<?> query, String field, Object value, JsonNbType jsonType, List<JsonPropMeteData> props) {
        Assert.notEmpty(props, (String)"json\u5c5e\u6027\u672a\u5b9a\u4e49\u67e5\u8be2\u5931\u8d25", (Object[])new Object[0]);
        InputNbTable inputNbTable = new InputNbTable(StrUtil.format((CharSequence)"jsonb_array_elements({})", (Object[])new Object[]{field}), props);
        JSONObject qrs = value instanceof JSONArray ? new JSONObject().set(OPERATOR_AND, value) : (JSONObject)value;
        String alias = "json_item";
        NbQuerier sub = NbQuerier.from(NbQuerier.table((INbTable)inputNbTable, alias).field("").additionFields(QueryExprParser.buildJsonFields(alias, props)), "json_arr").whereQrs(qrs);
        query.buildConnect(sub);
        query.where(StrUtil.format((CharSequence)"({})>0", (Object[])new Object[]{sub.buildFuncSql("count(*)")}));
    }

    public static List<String> buildJsonFields(String columnName, List<JsonPropMeteData> props) {
        ArrayList<String> fields = new ArrayList<String>();
        for (JsonPropMeteData prop : props) {
            String propName = StrUtil.toUnderlineCase((CharSequence)prop.getName());
            fields.add(StrUtil.format((CharSequence)"({}->>'{}')::{} {}", (Object[])new Object[]{columnName, propName, prop.getQueryType().getDbTypeSql(), propName}));
        }
        return fields;
    }

    private static void parseOperation(NbQuerier<?> query, String fieldName, String k2, Object v2) {
        if (OPERATOR_JSON.equals(k2)) {
            QueryExprParser.parseJsonExpr(query, fieldName, v2);
            return;
        }
        QueryRuleEnum rule = QueryRuleEnum.parse(StrUtil.removePrefix((CharSequence)k2, (CharSequence)OPERATOR));
        if (rule == QueryRuleEnum.IN || rule == QueryRuleEnum.NOT_IN) {
            Assert.isInstanceOf(Collection.class, (Object)v2, (String)"\u64cd\u4f5c\u7b26:{},\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4", (Object[])new Object[]{rule});
            if (CollUtil.isEmpty((Collection)Convert.toList((Object)v2))) {
                return;
            }
        }
        query.where(fieldName, rule, v2);
    }

    static {
        log = LoggerFactory.getLogger(QueryExprParser.class);
    }

    static enum RootOperator {
        OPERATOR_OR("$or"),
        OPERATOR_AND("$and"),
        OPERATOR_FIELD("$field");

        private String key;

        private RootOperator(String key) {
            this.key = key;
        }

        public static RootOperator convertFromKey(String key) {
            for (RootOperator value : RootOperator.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            throw new NbSQLMessageException("\u672a\u77e5\u64cd\u4f5c\u7b26\u7c7b\u578b:{}", key);
        }

        public String getKey() {
            return this.key;
        }
    }
}

