/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.querier.condition;

import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.querier.condition.DoConditionTopside;
import cn.hperfect.nbquerier.enums.NbOrderType;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;

public interface DefaultDoCondition<T>
extends DoConditionTopside<T> {
    default public NbQuerier<T> wherePk(QueryRuleEnum ruleEnum, Object value) {
        Assert.notNull((Object)value, (String)"pk\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.where(this.getPkName(), ruleEnum, value);
    }

    default public NbQuerier<T> wherePk(Object value) {
        return this.wherePk(QueryRuleEnum.EQ, value);
    }

    default public NbQuerier<T> whereAny(String field, Object value) {
        return this.whereAny(field, value, false);
    }

    default public NbQuerier<T> whereNotAny(String field, Object value) {
        return this.where(field, QueryRuleEnum.NOT_ANY, value, false);
    }

    default public NbQuerier<T> whereAny(String field, Object value, boolean required) {
        return this.where(field, QueryRuleEnum.ANY, value, required);
    }

    default public NbQuerier<T> whereLike(String field, String search) {
        return this.where(field, QueryRuleEnum.LIKE, (Object)search);
    }

    default public NbQuerier<T> whereLikeRight(String field, String search) {
        return this.where(field, QueryRuleEnum.LIKE, (Object)(search + "%"));
    }

    default public NbQuerier<T> whereLikeLeft(String field, String search) {
        return this.where(field, QueryRuleEnum.LIKE, (Object)("%" + search));
    }

    default public NbQuerier<T> whereQrs(String qrs) {
        JSONObject jsonObject = null;
        if (StrUtil.isNotBlank((CharSequence)qrs)) {
            try {
                jsonObject = JSONUtil.parseObj((String)qrs);
            }
            catch (Throwable throwable) {
                throw new NbSQLMessageException("qrs\u683c\u5f0f\u9519\u8bef", new Object[0]);
            }
        }
        return this.whereQrs(jsonObject);
    }

    default public NbQuerier<T> whereQrs(Map<String, Object> qrs) {
        return this.whereQrs(qrs == null ? null : new JSONObject(qrs));
    }

    default public NbQuerier<T> where(String field, Object value, boolean notNull) {
        return this.where(field, QueryRuleEnum.EQ, value, notNull);
    }

    default public NbQuerier<T> where(String field, QueryRuleEnum ruleEnum, Object value) {
        return this.where(field, ruleEnum, value, false);
    }

    default public NbQuerier<T> where(String field, String condition, Object value) {
        return this.where(field, QueryRuleEnum.parse(condition), value);
    }

    default public NbQuerier<T> whereInters(String field, Collection<?> list) {
        Assert.isFalse((boolean)CollUtil.isEmpty(list), (String)("\u5b57\u6bb5:" + field + "\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        return this.where(field, QueryRuleEnum.INTERS, list);
    }

    @Override
    default public NbQuerier<T> whereIn(String field, Collection<?> list) {
        return this.whereIn(field, list, true);
    }

    default public NbQuerier<T> whereIn(String field, Collection<?> list, boolean notNull) {
        Assert.isFalse((CollUtil.isEmpty(list) && notNull ? 1 : 0) != 0, (String)("\u5b57\u6bb5:" + field + "\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
        return this.where(field, QueryRuleEnum.IN, list, notNull);
    }

    @Override
    default public NbQuerier<T> whereNotIn(String field, Collection<?> list) {
        return this.where(field, QueryRuleEnum.NOT_IN, list, false);
    }

    public NbQuerier<T> whereOr(Consumer<NbQuerier<T>> var1);

    default public NbQuerier<T> whereNotNull(String field) {
        return this.where(field, QueryRuleEnum.NOT_NULL, null, false);
    }

    default public NbQuerier<T> whereNull(String field) {
        return this.where(field, QueryRuleEnum.NULL, null, false);
    }

    default public NbQuerier<T> whereOrNull(String field, Object value) {
        return this.where((NbQuerier<T> i) -> i.where(field, value, true).or().whereNull(field));
    }

    default public NbQuerier<T> where(String field, Object value) {
        return this.where(field, value, false);
    }

    default public NbQuerier<T> whereExpr(String sql, QueryValParam ... value) {
        return this.where(this.parseSqlParam(sql, value));
    }

    public NbQuerier<T> page(int var1, int var2);

    default public NbQuerier<T> limit(int length) {
        Assert.isTrue((length >= 0 ? 1 : 0) != 0, (String)"limit length\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e0", (Object[])new Object[0]);
        return this.last("LIMIT " + length);
    }

    default public NbQuerier<T> order(String sort, String ... fields) {
        return this.order(NbOrderType.parse(sort), fields);
    }

    default public NbQuerier<T> asc(String ... fields) {
        return this.order(NbOrderType.ASC, fields);
    }

    default public NbQuerier<T> desc(String ... fields) {
        return this.order(NbOrderType.DESC, fields);
    }
}

