/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.querier;

import cn.hperfect.nbquerier.annotation.NbView;
import cn.hperfect.nbquerier.annotation.TableJoin;
import cn.hperfect.nbquerier.config.NbQuerierConfigFactory;
import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.metedata.ConditionAgg;
import cn.hperfect.nbquerier.core.metedata.INbExecuteBatch;
import cn.hperfect.nbquerier.core.metedata.JoinTableRule;
import cn.hperfect.nbquerier.core.metedata.NbExecuteBatch;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.OrderInfoStr;
import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.metedata.table.VirtualTable;
import cn.hperfect.nbquerier.core.querier.DefaultNbQuerier;
import cn.hperfect.nbquerier.core.querier.IResultMap;
import cn.hperfect.nbquerier.core.querier.execute.DoFunction;
import cn.hperfect.nbquerier.core.querier.execute.DoUpdate;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.enums.NbOrderType;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;

public interface NbQuerier<T>
extends ISqlSegment,
DoFunction<T>,
DoUpdate<T>,
IResultMap<T> {
    public static INbExecuteBatch startBatch(int size) {
        return new NbExecuteBatch(size);
    }

    public static INbExecutor newExecutor() {
        return ((NbQuerierConfiguration)SpringUtil.getBean(NbQuerierConfiguration.class)).newNbExecutor();
    }

    public MergeSegments getExpression();

    public static <T> NbQuerier<T> table(Class<T> clazz) {
        return NbQuerier.table(clazz, null);
    }

    public static NbQuerier<?> wrapper(NbQuerier<?> fromQuerier) {
        return NbQuerier.wrapper(fromQuerier, fromQuerier.getTableAlias(fromQuerier.getTableName()));
    }

    public static NbQuerier<?> wrapper(NbQuerier<?> fromQuerier, String alias) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        DefaultNbQuerier result = builder.newNbQuerier();
        NbQueryInfo queryInfo = new NbQueryInfo();
        queryInfo.setQueryType(QueryType.FORM_QUERY);
        queryInfo.setAlias(alias);
        String virtualTableName = String.format("#{sub_%s}", alias);
        ArrayList<ClassNbField> nbFields = new ArrayList<ClassNbField>();
        VirtualTable virtualTable = new VirtualTable(virtualTableName, null, new PrimaryKey(), nbFields);
        for (INbField iNbField : fromQuerier.getQueryInfo().getFields()) {
            if (iNbField.getFieldType() == NbFieldType.DELETE) continue;
            ClassNbField nbField = new ClassNbField();
            nbFields.add(nbField);
            nbField.setName(iNbField.getName());
            nbField.setFieldType(iNbField.getFieldType());
            nbField.setTable(virtualTable);
            if (iNbField.getFieldType() != NbFieldType.ORDER) continue;
            String tableAlias = (String)fromQuerier.getTableAliasMap().get((Object)iNbField.getTableName());
            fromQuerier.additionField(SqlUtils.withAlias(tableAlias, iNbField.getName()));
        }
        queryInfo.setTable(virtualTable);
        queryInfo.setFromQuerier(fromQuerier);
        result.setQueryInfo(queryInfo);
        DefaultNbQuerier defaultNbQuerier = (DefaultNbQuerier)fromQuerier;
        result.setParamBuilder(defaultNbQuerier.getParamBuilder());
        return result;
    }

    public static NbQuerier<?> from(NbQuerier<?> fromQuerier, String alias) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        DefaultNbQuerier result = builder.newNbQuerier();
        NbQueryInfo queryInfo = new NbQueryInfo();
        queryInfo.setQueryType(QueryType.FORM_QUERY);
        queryInfo.setAlias(alias);
        queryInfo.setFromQuerier(fromQuerier);
        NbQueryInfo fromQuerierInfo = fromQuerier.getQueryInfo();
        queryInfo.setTable(fromQuerierInfo.getTable());
        result.setQueryInfo(queryInfo);
        return result;
    }

    public static <T> NbQuerier<T> table(INbTable table) {
        return NbQuerier.table(table, null, null);
    }

    public static <T> NbQuerier<T> table(NbQuerier<?> querier, Class<T> clazz) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        return builder.build(querier, clazz);
    }

    public static <T> NbQuerier<T> table(INbTable table, @Nullable Class<T> clazz) {
        return NbQuerier.table(table, clazz, null);
    }

    public static <T> NbQuerier<T> table(INbTable table, String alias) {
        return NbQuerier.table(table, null, alias);
    }

    public static <T> NbQuerier<T> table(Class<T> clazz, String alias) {
        INbQueryBuilder builder = NbQuerierConfigFactory.INSTANCE.getConfiguration().getNbQueryBuilder();
        return builder.build(clazz, alias);
    }

    public static <T> NbQuerier<T> table(INbTable table, @Nullable Class<T> tableClazz, String alias) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        return builder.build(table, tableClazz, alias);
    }

    public static <T> NbQuerier<T> table(NbQueryInfo queryInfo) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        return builder.build(queryInfo);
    }

    @Deprecated
    public static <T> NbQuerier<T> view(Class<T> viewClazz, Class<?> tableClazz, String alias) {
        INbQueryBuilder builder = (INbQueryBuilder)SpringUtil.getBean(INbQueryBuilder.class);
        NbQueryInfo queryInfo = builder.buildQueryInfo(tableClazz, alias);
        NbQuerier<T> querier = builder.build(queryInfo);
        return querier.setResultClass(viewClazz);
    }

    @Deprecated
    public static <T> NbQuerier<T> view(Class<T> view) {
        NbView nbView = view.getAnnotation(NbView.class);
        Assert.notNull((Object)nbView, (String)"@NbView\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        NbQuerier<T> querier = NbQuerier.view(view, nbView.masterTable(), nbView.alias());
        TableJoin[] joins = nbView.joins();
        if (joins.length > 0) {
            for (TableJoin join : joins) {
                querier.leftJoin(join.joinTable(), join.alias());
            }
        }
        return querier;
    }

    public NbQuerier<T> addRowNum(String var1, String var2, String var3);

    public NbQuerier<T> additionField(String var1);

    public NbQuerier<T> additionFields(List<String> var1);

    public NbQuerier<T> field(String var1);

    default public NbQuerier<T> emptyField() {
        return this.field("");
    }

    default public NbQuerier<T> field(SFunction<T, ?> field) {
        return this.field(this.getFieldName(field));
    }

    default public NbQuerier<T> field(SFunction<T, ?> ... fields) {
        return this.field(CollUtil.join(Arrays.asList(this.getFieldNames(Arrays.asList(fields))), (CharSequence)","));
    }

    default public NbQuerier<T> field(List<SFunction<T, ?>> fields) {
        return this.field(CollUtil.join(Arrays.asList(this.getFieldNames(fields)), (CharSequence)","));
    }

    public NbQuerier<T> leftJoin(Class<?> var1, String var2, String var3);

    public <F, E> NbQuerier<T> leftJoin(Class<F> var1, String var2, SFunction<F, E> var3, SFunction<T, E> var4);

    public NbQuerier<T> leftJoin(Class<?> var1, String var2);

    public NbQuerier<T> leftJoin(NbQueryInfo var1, String var2, boolean var3);

    default public NbQuerier<T> leftJoin(NbQueryInfo queryInfo, String on) {
        return this.leftJoin(queryInfo, on, false);
    }

    @Deprecated
    public NbQuerier<T> leftJoin(NbQuerier<?> var1, String var2);

    default public NbQuerier<T> leftJoin(NbQuerier<?> querier, String alias, String on) {
        return this.leftJoin(querier, alias, on, false);
    }

    public NbQuerier<T> leftJoin(NbQuerier<?> var1, String var2, String var3, boolean var4);

    public QueryField findQueryField(String var1, String var2);

    public QueryField findQueryField(String var1);

    default public NbQuerier<T> with(Consumer<NbQuerier<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    default public NbQuerier<T> addQueryField(String name, INbQueryType type) {
        this.getQueryFields().add(new QueryField().setName(name).setType(type));
        return this;
    }

    default public NbQuerier<T> with(Boolean condition, Consumer<NbQuerier<T>> consumer) {
        if (BooleanUtil.isTrue((Boolean)condition)) {
            return this.with(consumer);
        }
        return this;
    }

    public List<QueryValParam> getParams();

    public List<ConditionAgg> getConditionAggList();

    public List<JoinTableRule> getJoins();

    public String formatVariable(INbQueryType var1, Object var2, boolean var3);

    public String formatVariable(QueryValParam var1);

    public String formatVariable(INbQueryType var1, Object var2, boolean var3, boolean var4);

    default public NbQuerier<T> dataScope(List<Object> dataScope) {
        Assert.notEmpty(dataScope, (String)"\u6570\u636e\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.getQueryInfo().setDataScope(dataScope);
        return this;
    }

    default public NbQuerier<T> dataPerm(Object dataScope) {
        this.getQueryInfo().setPermValue(dataScope);
        return this;
    }

    default public NbQuerier<T> dataScope(Object dataScope) {
        return this.dataScope(ListUtil.toList((Object[])new Object[]{dataScope}));
    }

    public boolean hasWhere();

    default public NbQuerier<T> withDelete() {
        this.getQueryInfo().setWithDelete(true);
        return this;
    }

    public NbQuerier<T> alias(String var1);

    public NbQuerier<T> withMany(String var1, NbQuerier<?> var2);

    public NbQuerier<T> withOne(String var1, NbQuerier<?> var2);

    default public NbQuerier<T> withOne(SFunction<T, ?> fieldName, NbQuerier<?> querier) {
        return this.withOne(this.getFieldName(fieldName), querier);
    }

    public String buildConnect(NbQuerier<?> var1);

    public String connectParam(NbQuerier<?> var1, String var2);

    default public NbQuerier<T> withMany(SFunction<T, List<?>> fieldName, NbQuerier<?> querier) {
        return this.withMany(fieldName, querier, true);
    }

    default public NbQuerier<T> withMany(SFunction<T, List<?>> fieldName, NbQuerier<?> querier, boolean inline) {
        return this.withMany(this.getFieldName(fieldName, false), querier);
    }

    public NbQuerier<T> withManyCount(String var1, NbQuerier<?> var2);

    default public NbQuerier<T> withManyCount(SFunction<T, ?> fieldName, NbQuerier<?> querier) {
        return this.withManyCount(this.getFieldName(fieldName, false), querier);
    }

    public NbQuerier<T> union(NbQuerier<T> var1);

    public NbQuerier<T> unionAll(NbQuerier<T> var1);

    public NbQuerier<T> having(String var1);

    public NbQuerier<T> group(String ... var1);

    default public NbQuerier<T> group(SFunction<T, ?> column) {
        return this.group(this.getFieldName(column));
    }

    default public NbQuerier<T> fieldReplace(boolean val) {
        this.getQueryInfo().setFieldReplace(val);
        return this;
    }

    public NbQuerier<T> autoOrder();

    public NbQuerier<T> updateExpr(String var1);

    default public NbQuerier<T> updateExpr(String sql, QueryValParam ... params) {
        return this.updateExpr(this.parseSqlParam(sql, params));
    }

    @Deprecated
    public NbQuerier<T> updateExpr(String var1, Object ... var2);

    public QueryField findField(String var1);

    default public NbQuerier<T> updateRemoveArrayItem(SFunction<T, ?> fieldFunc, Object item) {
        String fieldName = this.getFieldName(fieldFunc);
        QueryField field = this.findField(fieldName);
        INbQueryType type = field.getType();
        Assert.isTrue((boolean)type.isArray(), (String)"\u53ea\u652f\u6301\u6570\u7ec4\u7c7b\u578b\u79fb\u9664\u5143\u7d20", (Object[])new Object[0]);
        String param = this.formatVariable(type.getArraySubType(), item, true);
        String sql = StrUtil.format((CharSequence)"{}=array_remove({},{})", (Object[])new Object[]{field.getName(), field.getName(), param});
        return this.updateExpr(sql);
    }

    public NbQuerier<T> setResultClass(Class<T> var1);

    public NbQuerier<T> tableSchema(String var1);

    default public String getTableName() {
        return this.getQueryInfo().getTableName();
    }

    default public NbQuerier<T> order(List<OrderInfoStr> defaultOrderInfos) {
        for (OrderInfoStr defaultOrderInfo : defaultOrderInfos) {
            this.order(NbOrderType.parse(defaultOrderInfo.getOrder()), defaultOrderInfo.getNullsPosition(), defaultOrderInfo.getOrderBy());
        }
        return this;
    }

    default public NbQuerier<T> allowSetNull() {
        this.getQueryInfo().setAllowSetNull(true);
        return this;
    }

    public String getDsName();

    public NbQuerier<T> lock();

    public NbQuerier<T> setConnection(Connection var1);

    public NbQuerier<T> setTx(INbTransaction var1);

    public NbQuerier<T> batch(INbExecuteBatch var1);
}

