/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.querier;

import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.builder.INbSqlBuilder;
import cn.hperfect.nbquerier.core.components.builder.impl.ParamBuilder;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.components.executor.options.DoUpdateOptions;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.conditions.ILaterQuerier;
import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.func.BuildInFunc;
import cn.hperfect.nbquerier.core.metedata.ConditionAgg;
import cn.hperfect.nbquerier.core.metedata.INbExecuteBatch;
import cn.hperfect.nbquerier.core.metedata.IQueryItem;
import cn.hperfect.nbquerier.core.metedata.JoinTableRule;
import cn.hperfect.nbquerier.core.metedata.JsonPropQueryItem;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.OrderInfo;
import cn.hperfect.nbquerier.core.metedata.PageInfo;
import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hperfect.nbquerier.core.metedata.QueryFields;
import cn.hperfect.nbquerier.core.metedata.QueryItem;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.metedata.ResultConsumer;
import cn.hperfect.nbquerier.core.metedata.custom.BaseCustomEntity;
import cn.hperfect.nbquerier.core.metedata.custom.CustomEntityBuilder;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.querier.UpdateData;
import cn.hperfect.nbquerier.core.metedata.table.ClassNbTable;
import cn.hperfect.nbquerier.core.metedata.table.ThisTable;
import cn.hperfect.nbquerier.core.metedata.table.VirtualTable;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.querier.qrs.QueryExprParser;
import cn.hperfect.nbquerier.core.registry.NbInterceptorRegistry;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.IdType;
import cn.hperfect.nbquerier.enums.JoinType;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.enums.NbOrderType;
import cn.hperfect.nbquerier.enums.NullsPosition;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.enums.ResultType;
import cn.hperfect.nbquerier.enums.SqlKeyword;
import cn.hperfect.nbquerier.enums.WrapperKeyword;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.toolkit.BuildUtils;
import cn.hperfect.nbquerier.toolkit.LambdaUtils;
import cn.hperfect.nbquerier.toolkit.NbEnumUtils;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hperfect.nbquerier.toolkit.map.UnderlineCaseMap;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hperfect.nbquerier.toolkit.support.SerializedLambda;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class DefaultNbQuerier<T>
implements NbQuerier<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultNbQuerier.class);
    private final INbSqlBuilder sqlBuilder;
    private final INbQueryBuilder queryBuilder;
    private final NbQuerierProperties config;
    private final NbInterceptorRegistry interceptorChain;
    private final IDialectWare dialectWare;
    private final NbQuerierConfiguration configuration;
    private NbQueryInfo queryInfo;
    private INbExecuteBatch batch;
    private Class<T> resultClass;
    private final List<JoinTableRule> joins = new ArrayList<JoinTableRule>();
    private List<ConditionAgg> conditionAggList;
    protected QueryFields queryFields = new QueryFields();
    private ParamBuilder paramBuilder = new ParamBuilder();
    protected MergeSegments expression = new MergeSegments();
    protected String lastSql;
    private Connection connection;
    private INbTransaction tx;
    private ResultConsumer<T> resultConsumer = new ResultConsumer();
    private BiMap<String, String> tableAliasMap = new BiMap(new HashMap());
    private UpdateData updateData;

    public UpdateData safeGetUpdateData() {
        if (this.updateData == null) {
            this.updateData = new UpdateData();
        }
        return this.updateData;
    }

    public List<ConditionAgg> safeGetConditionAggList() {
        if (this.conditionAggList == null) {
            this.conditionAggList = new ArrayList<ConditionAgg>();
        }
        return this.conditionAggList;
    }

    public DefaultNbQuerier(NbQuerierConfiguration configuration) {
        this.configuration = configuration;
        try {
            this.config = configuration.getConfig();
            this.queryBuilder = configuration.getNbQueryBuilder();
            Assert.notNull((Object)this.queryBuilder, (String)"queryBuilder\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.sqlBuilder = configuration.getNbSqlBuilder();
            Assert.notNull((Object)this.queryBuilder, (String)"SqlBuilder\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.interceptorChain = configuration.getNbInterceptorRegistry();
            Assert.notNull((Object)this.interceptorChain, (String)"interceptorChain\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.dialectWare = configuration.getDialectWare();
            Assert.notNull((Object)this.interceptorChain, (String)"dialectWare \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        catch (Exception throwable) {
            throw new NbSQLMessageException("\u521b\u5efa\u67e5\u8be2\u5bf9\u8c61\u5931\u8d25:" + throwable.getMessage(), new Object[0]);
        }
    }

    public void setQueryInfo(NbQueryInfo nbQueryInfo) {
        this.queryInfo = nbQueryInfo;
        if (ThisTable.ME.equals(nbQueryInfo.getTable())) {
            return;
        }
        Assert.isFalse((boolean)this.tableAliasMap.containsKey((Object)nbQueryInfo.getSql()), (String)"\u5df2\u5b58\u5728\u8be5\u522b\u540d", (Object[])new Object[0]);
        this.tableAliasMap.put((Object)nbQueryInfo.getTableName(), (Object)nbQueryInfo.getAlias());
        Assert.notNull(nbQueryInfo.getFields(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<QueryField> list = nbQueryInfo.getFields().stream().filter(INbField::isQuery).map(i -> new QueryField(i.getQueryType(), i.getName(), (String)ObjectUtil.defaultIfBlank((CharSequence)i.getTableName(), (CharSequence)nbQueryInfo.getTableName()), null, i.getRedirect())).collect(Collectors.toList());
        this.queryFields.puts(list);
    }

    @Override
    public NbQuerier<T> where(Consumer<NbQuerier<T>> consumer) {
        MergeSegments old = this.expression;
        this.expression = new MergeSegments();
        consumer.accept(this);
        if (this.hasWhere()) {
            old.add(WrapperKeyword.APPLY, this.expression);
        }
        this.expression = old;
        return this;
    }

    @Override
    public NbQuerier<T> whereOr(Consumer<NbQuerier<T>> consumer) {
        MergeSegments old = this.expression;
        this.expression = new MergeSegments();
        consumer.accept(this);
        if (this.hasWhere()) {
            MergeSegments temp = this.expression;
            this.expression = old;
            this.or().getExpression().add(WrapperKeyword.APPLY, temp);
        } else {
            this.expression = old;
        }
        return this;
    }

    @Override
    public NbQuerier<T> whereExists(NbQuerier<?> querier) {
        String subSql = this.buildConnect(querier);
        this.expression.add(QueryRuleEnum.EXISTS, () -> "(" + subSql + ")");
        return this;
    }

    @Override
    public NbQuerier<T> whereIn(String field, NbQuerier<?> querier) {
        String subSql = this.buildConnect(querier);
        return this.where(field, QueryRuleEnum.IN, () -> "(" + subSql + ")", true);
    }

    @Override
    public NbQuerier<T> whereNotIn(String field, NbQuerier<?> querier) {
        String subSql = this.buildConnect(querier);
        return this.where(field, QueryRuleEnum.NOT_IN, () -> "(" + subSql + ")", true);
    }

    @Override
    public <G, K> String getFieldName(SFunction<G, K> function, boolean withAlias) {
        SerializedLambda resolve = LambdaUtils.resolve(function);
        Class<T> implClass = resolve.getImplClass();
        if (this.resultClass != null && implClass.isAssignableFrom(this.resultClass)) {
            implClass = this.resultClass;
        }
        String tableName = this.queryBuilder.parseTableInfo(implClass).getTableName();
        String alias = (String)this.tableAliasMap.get((Object)tableName);
        String field = StrUtil.removePrefix((CharSequence)resolve.getImplMethodName(), (CharSequence)"get");
        String underField = StrUtil.toUnderlineCase((CharSequence)field);
        return withAlias ? SqlUtils.withAlias(alias, underField) : underField;
    }

    @Override
    public NbQuerier<T> or() {
        this.expression.add(SqlKeyword.OR);
        return this;
    }

    @Override
    public NbQuerier<T> setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    @Override
    public NbQuerier<T> batch(INbExecuteBatch nbBatch) {
        this.batch = nbBatch;
        return this;
    }

    @Override
    public NbQuerier<T> not() {
        this.expression.add(SqlKeyword.NOT);
        return this;
    }

    @Override
    public NbQuerier<T> where(String sql) {
        this.expression.add(WrapperKeyword.APPLY, () -> sql);
        return this;
    }

    @Override
    public NbQuerier<T> whereQrs(JSONObject qrs) {
        if (qrs != null) {
            QueryExprParser.parseJsonObjectToCondition(this, qrs);
        }
        return this;
    }

    @Override
    public NbQuerier<T> where(String field, QueryRuleEnum ruleEnum, Object value, boolean notNull) {
        Assert.isFalse((notNull && value == null ? 1 : 0) != 0, (String)"\u6761\u4ef6\u67e5\u8be2,\u5b57\u6bb5:{}\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{field});
        Assert.notEmpty((CharSequence)field, (String)"\u67e5\u8be2\u6761\u4ef6\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        QueryItem queryItem = new QueryItem(field);
        return this.where(queryItem, ruleEnum, value, notNull);
    }

    @Override
    public NbQuerier<T> where(IQueryItem iQueryItem, QueryRuleEnum ruleEnum, Object value, boolean notNull) {
        INbQueryType type = null;
        if (iQueryItem instanceof QueryItem) {
            QueryItem queryItem = (QueryItem)iQueryItem;
            QueryField queryField = BuildUtils.findOne(this.queryFields, queryItem, this.queryInfo.getTableName(), this.tableAliasMap);
            assert (queryField != null) : "\u4e0d\u5b58\u5728\u5b57\u6bb5:" + queryItem.getName();
            if (StrUtil.isNotBlank((CharSequence)queryField.getWhereRedirect())) {
                queryItem.setSub(true);
                queryItem.setSql(queryField.getWhereRedirect());
            } else if (StrUtil.isNotBlank((CharSequence)queryField.getRedirect())) {
                queryItem.setName(queryField.getRedirect());
                return this.where(queryItem.getExpr(), ruleEnum, value, notNull);
            }
            queryItem.setTableAlias((String)this.tableAliasMap.get((Object)queryField.getTableName()));
            type = queryField.getType();
            if (type == NbQueryType.MAP_ENUM_LIST && this.getQueryInfo().isClass()) {
                value = NbEnumUtils.getEnumListNewValue(this.queryInfo.getFields(), (Collection)value, queryItem.getName());
            } else if (type == NbQueryType.MAP_ENUM && this.getQueryInfo().isClass()) {
                value = NbEnumUtils.getEnumNewValue(this.queryInfo.getFields(), value, queryItem.getName());
            }
        } else if (iQueryItem instanceof JsonPropQueryItem) {
            JsonPropQueryItem jsonPropQueryItem = (JsonPropQueryItem)iQueryItem;
            type = jsonPropQueryItem.getQueryType();
        } else {
            throw new NbSQLMessageException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b", new Object[0]);
        }
        String name = iQueryItem.getExpr();
        type.setWhereCondition(this, this.expression, ruleEnum, name, value);
        return this;
    }

    private boolean hasValue(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof CharSequence) || !StrUtil.isBlank((CharSequence)((CharSequence)value));
    }

    @Override
    public <F> List<F> column(String field) {
        field = StrUtil.toUnderlineCase((CharSequence)field);
        this.field(field);
        ArrayList<Object> list = new ArrayList<Object>();
        List<LinkedHashMap<String, Object>> linkedHashMaps = this.selectMap();
        if (CollUtil.isEmpty(linkedHashMaps)) {
            return list;
        }
        for (LinkedHashMap<String, Object> map : linkedHashMaps) {
            if (map == null) continue;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                list.add(entry.getValue());
            }
        }
        return list;
    }

    @Override
    public NbQuerier<T> page(int pageNo, int pageSize) {
        this.queryInfo.setPageInfo(new PageInfo(pageNo, pageSize));
        return this;
    }

    @Override
    public NbQuerier<T> limit(int offset, int length) {
        this.dialectWare.limit(this, offset, length);
        return this;
    }

    @Override
    public NbQuerier<T> last(String last) {
        this.lastSql = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{this.lastSql, " ", last});
        return this;
    }

    @Override
    public NbQuerier<T> union(NbQuerier<T> querier) {
        throw new NbSQLMessageException("union \u65b9\u6cd5\u5f85\u5b9e\u73b0", new Object[0]);
    }

    @Override
    public NbQuerier<T> unionAll(NbQuerier<T> querier) {
        List<NbQuerier<?>> unionAllQueries = this.getQueryInfo().getUnionAllQueries();
        if (unionAllQueries == null) {
            unionAllQueries = new ArrayList();
            this.queryInfo.setUnionAllQueries(unionAllQueries);
        }
        unionAllQueries.add(querier);
        return this;
    }

    @Override
    public NbQuerier<T> where(T t) {
        Assert.notNull(this.resultClass, (String)"tableClazz \u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Map<String, Object> map = this.beanToMap(t);
        if (MapUtil.isNotEmpty(map)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                this.where(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public NbQuerier<T> having(String sqlHaving) {
        this.expression.add(SqlKeyword.HAVING, () -> sqlHaving);
        return this;
    }

    @Override
    public NbQuerier<T> leftJoin(Class<?> clazz, String alias, String on) {
        return this.leftJoin(this.getJoinQueryInfo(clazz, alias), on);
    }

    @Override
    public <F, E> NbQuerier<T> leftJoin(Class<F> clazz, String alias, SFunction<F, E> tableAField, SFunction<T, E> tableBField) {
        NbQueryInfo joinQueryInfo = this.getJoinQueryInfo(clazz, alias);
        String tableAFieldName = this.getFieldName(tableAField);
        String tableBFieldName = this.getFieldName(tableBField);
        return this.leftJoin(joinQueryInfo, tableAFieldName + '=' + tableBFieldName);
    }

    @Override
    public NbQuerier<T> leftJoin(Class<?> clazz, String alias) {
        NbQueryInfo join = this.getJoinQueryInfo(clazz, alias);
        return this.leftJoin(join, this.parseJoinOn(alias, join));
    }

    @Override
    public NbQuerier<T> leftJoin(NbQuerier<?> querier, String alias) {
        Assert.isTrue((boolean)querier.getQueryInfo().isClass(), (String)"\u53ea\u652f\u6301class \u7c7b\u578b\u81ea\u52a8\u8fde\u8868", (Object[])new Object[0]);
        ClassNbTable table = (ClassNbTable)querier.getQueryInfo().getTable();
        NbQueryInfo join = this.getJoinQueryInfo(table.getTableClass(), alias);
        return this.leftJoin(this.queryInfo, this.parseJoinOn(alias, join));
    }

    private NbQueryInfo getJoinQueryInfo(Class<?> clazz, String alias) {
        NbQueryInfo join = this.queryBuilder.buildQueryInfo(clazz, alias);
        Assert.isFalse((boolean)CollUtil.contains((Collection)this.tableAliasMap.values(), i -> i.equals(alias)), (String)"\u8be5\u67e5\u8be2\u6784\u9020\u5668\u4e2d\u5df2\u5b58\u5728\u522b\u540d:{},class:{}", (Object[])new Object[]{alias, clazz});
        this.tableAliasMap.put((Object)join.getTableName(), (Object)alias);
        return join;
    }

    private String parseJoinOn(String alias, NbQueryInfo join) {
        INbField one = (INbField)CollUtil.findOne(this.queryInfo.getFields(), i -> i.isFk() && i.getJoinTable() != null && StrUtil.equals((CharSequence)i.getJoinTable().getTableName(), (CharSequence)join.getTableName()));
        if (one == null && (one = (INbField)CollUtil.findOne(join.getFields(), i -> i.getFieldType() == NbFieldType.FK && i.getJoinTable().getTableName().equals(this.queryInfo.getTableName()))) != null) {
            String masterAlias = (String)this.tableAliasMap.get((Object)this.queryInfo.getTableName());
            return StrUtil.format((CharSequence)"{}={}", (Object[])new Object[]{SqlUtils.withAlias(alias, this.getQueryInfo().getPkName()), SqlUtils.withAlias(masterAlias, one.getName())});
        }
        String on = null;
        if (one == null && CollUtil.isNotEmpty(this.joins)) {
            JoinTableRule joinTableRule;
            Iterator<JoinTableRule> iterator = this.joins.iterator();
            while (iterator.hasNext() && !StrUtil.isNotBlank((CharSequence)(on = this.parseJoinOn((joinTableRule = iterator.next()).getQueryInfo().getAlias(), joinTableRule.getQueryInfo())))) {
            }
        }
        if (one != null) {
            String masterAlias = (String)this.tableAliasMap.get((Object)this.queryInfo.getTableName());
            String fieldName = one.getName();
            on = StrUtil.format((CharSequence)"{}={}", (Object[])new Object[]{SqlUtils.withAlias(alias, join.getPkName()), SqlUtils.withAlias(masterAlias, fieldName)});
        }
        Assert.notBlank(on, (String)"\u8868\u5355{},\u672a\u627e\u5230\u5173\u8054\u8868\u5355:{}\u7684\u5916\u952e\u5b57\u6bb5", (Object[])new Object[]{this.queryInfo.getTableName(), join.getTableName()});
        return on;
    }

    @Override
    public NbQuerier<T> leftJoin(NbQueryInfo queryInfo, String on, boolean lateral) {
        this.joins.add(new JoinTableRule(queryInfo, JoinType.LEFT_JOIN, on, lateral));
        this.tableAliasMap.put((Object)queryInfo.getTableName(), (Object)queryInfo.getAlias());
        if (queryInfo.isSub()) {
            this.queryFields.puts(queryInfo.getQueryFields());
        } else {
            List<QueryField> fields = queryInfo.getFields().stream().map(i -> new QueryField(i.getQueryType(), i.getName(), queryInfo.getTableName(), null, i.getRedirect())).collect(Collectors.toList());
            this.queryFields.puts(fields);
        }
        return this;
    }

    @Override
    public NbQuerier<T> leftJoin(NbQuerier<?> querier, String alias, String on, boolean lateral) {
        String sql = this.buildConnect(querier);
        NbQueryInfo info = this.queryBuilder.buildQueryInfo(querier, alias);
        info.setSql(sql);
        info.setAlias(alias);
        info.setQueryType(QueryType.SUB);
        String virtualTableName = String.format("#{sub_%s}", alias);
        info.setQueryFields(new QueryFields(querier.getQueryFields().fields().stream().map(i -> new QueryField(i.getType(), i.getName(), i.getTableName(), virtualTableName, null)).collect(Collectors.toList())));
        this.tableAliasMap.put((Object)virtualTableName, (Object)alias);
        Set tableSet = querier.getQueryFields().fields().stream().map(QueryField::getTableName).collect(Collectors.toSet());
        for (String s : tableSet) {
            this.tableAliasMap.put((Object)s, (Object)alias);
        }
        NbQueryInfo q = querier.getQueryInfo();
        VirtualTable virtualTable = new VirtualTable(virtualTableName, q.getTableName(), q.getPk(), ListUtil.empty());
        info.setVirtualTable(virtualTable);
        return this.leftJoin(info, on, lateral);
    }

    @Override
    public NbQuerier<T> addRowNum(String partitionBy, String orderField, String sort) {
        return this;
    }

    @Override
    public NbQuerier<T> field(String fieldStr) {
        this.queryInfo.setSetField(fieldStr);
        return this;
    }

    @Override
    public NbQuerier<T> order(NbOrderType sort, @Nullable NullsPosition nullsPosition, String ... fields) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return this;
        }
        for (String field : fields) {
            QueryItem queryItem = this.getColumnName(field, true);
            INbQueryType type = queryItem.getQueryField().getType();
            Assert.isTrue((boolean)type.orderAble(), (String)"\u5b57\u6bb5:{},\u7c7b\u578b:{},\u6682\u65f6\u4e0d\u652f\u6301\u6392\u5e8f", (Object[])new Object[]{field, type.getTitle()});
            ArrayList list = ListUtil.toList((Object[])new ISqlSegment[]{SqlKeyword.ORDER_BY, queryItem, sort.getKeyword()});
            if (nullsPosition != null) {
                list.add(SqlKeyword.NULLS);
                list.add(nullsPosition);
            }
            this.expression.add(list.toArray(new ISqlSegment[0]));
        }
        return this;
    }

    @Override
    public <F> List<F> select(Class<F> clazz) {
        Assert.isTrue((clazz != null ? 1 : 0) != 0, (String)"clazz \u4e3a\u7a7a\uff0c\u8bf7\u4f7f\u7528selectMap\u65b9\u6cd5", (Object[])new Object[0]);
        List<LinkedHashMap<String, Object>> linkedHashMaps = this.selectMap();
        return linkedHashMaps.stream().map(map -> this.mapToBean((Map<String, Object>)map, clazz)).collect(Collectors.toList());
    }

    @Override
    public T mapToBean(Map<String, Object> map) {
        Assert.notNull(this.resultClass, (String)"\u67e5\u8be2\u5bf9\u8c61\u7ed3\u679c\u7684class\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.mapToBean(map, this.resultClass);
    }

    private <F> F mapToBean(Map<String, Object> map, Class<F> clazz) {
        Object instance = null;
        if (map == null) {
            return null;
        }
        this.mapFieldAlias(map, false);
        boolean isCustomEntity = BaseCustomEntity.class.isAssignableFrom(clazz);
        try {
            if (isCustomEntity) {
                instance = CustomEntityBuilder.newInstance(clazz, map);
            } else {
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance = BeanUtil.fillBeanWithMap(map, instance, (boolean)true, (boolean)true);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u53cd\u5c04\u5bf9\u8c61\u5931\u8d25:", (Throwable)e);
            throw new NbSQLMessageException("class:{}\u53cd\u5c04\u67e5\u8be2\u5bf9\u8c61\u51fa\u73b0\u9519\u8bef", clazz.getSimpleName());
        }
        return (F)instance;
    }

    @Override
    public List<LinkedHashMap<String, Object>> selectMap() {
        INbExecutor executor = this.newExecutor();
        Assert.notNull((Object)executor, (String)"\u8be5\u6784\u9020\u5668\u4e0d\u80fd\u67e5\u8be2", (Object[])new Object[0]);
        String sql = this.buildQuerySql();
        List resultList = (List)executor.doQuery(this.getDsName(), sql, this.getParams(), ResultType.LIST);
        if (CollUtil.isNotEmpty((Collection)resultList)) {
            this.resultConsumer.doMapList(resultList);
        }
        return resultList;
    }

    @Override
    public String buildFuncSql(String funcName) {
        return this.sqlBuilder.buildFuncSql(this, funcName, false);
    }

    @Override
    public String buildQuerySql() {
        return this.sqlBuilder.buildQuerySql(this);
    }

    @Override
    public List<T> select() {
        List<T> list = this.select(this.resultClass);
        if (CollUtil.isNotEmpty(list)) {
            this.resultConsumer.doBeanList(list);
        }
        return list;
    }

    @Override
    public int update(boolean isDelete) {
        INbExecutor executor = this.newExecutor();
        Assert.notNull((Object)this.updateData, (String)"\u6ca1\u6709\u66f4\u65b0\u6570\u636e", (Object[])new Object[0]);
        HashMap value = new HashMap();
        this.updateData.getUpdateDataMap().forEach((k, v) -> value.put(k.getName(), v));
        if (!isDelete) {
            this.interceptorChain.doBeforeUpdate(this.getQueryInfo(), ListUtil.toList((Object[])new Map[]{value}));
        }
        String sql = this.sqlBuilder.buildUpdateSql(this, this.updateData);
        return this.executeUpdate(sql, executor);
    }

    @Override
    public int delete() {
        if (this.queryInfo.isSoftDelete()) {
            UpdateData ud = this.safeGetUpdateData();
            ud.clear();
            ud.put(this.queryInfo.getDeleteField(), LocalDateTime.now());
            return this.update(true);
        }
        String sql = this.sqlBuilder.buildDeleteSql(this);
        return this.newExecutor().doUpdate(this.getDsName(), sql, this.getParams());
    }

    @Override
    public INbExecutor newExecutor() {
        INbTransaction executeTx = null;
        executeTx = this.batch != null ? this.batch.getTx(this.configuration) : (this.tx != null ? this.tx : (this.connection == null ? this.configuration.newTx() : this.configuration.newTx(this.connection)));
        return this.configuration.newNbExecutor(executeTx);
    }

    @Override
    public NbQuerier<T> set(String field, Object value) {
        String tableName = this.queryInfo.getTableName();
        String uF = StrUtil.toUnderlineCase((CharSequence)field);
        INbField baseNbField = this.queryInfo.findField(uF);
        if (baseNbField == null) {
            return this;
        }
        Assert.notNull((Object)baseNbField, (String)"\u65e0\u6cd5\u66f4\u65b0\u5b57\u6bb5:{},\u539f\u56e0:\u8868:{},\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5", (Object[])new Object[]{uF, tableName});
        this.safeGetUpdateData().put(baseNbField, value);
        return this;
    }

    @Override
    @Nullable
    public QueryField findQueryField(String name, String table) {
        return this.queryFields.find(name, table);
    }

    @Override
    @Nullable
    public QueryField findQueryField(String name) {
        Collection<QueryField> fields = this.queryFields.findByName(name);
        if (CollUtil.isNotEmpty(fields)) {
            return (QueryField)fields.stream().iterator().next();
        }
        return null;
    }

    @Override
    public int save(Map<String, Object> data) {
        if (MapUtil.isEmpty(data)) {
            return 0;
        }
        this.interceptorChain.doBeforeSave(this.queryInfo, ListUtil.toList((Object[])new Map[]{data}));
        String sql = this.sqlBuilder.buildSaveSql((NbQuerier<?>)this, (Map<String, Object>)((Object)new UnderlineCaseMap<Object>(data)));
        INbExecutor executor = this.newExecutor();
        return this.executeUpdate(sql, executor);
    }

    private int executeUpdate(String sql, INbExecutor executor) {
        return executor.doUpdate(new DoUpdateOptions().setDsName(this.getDsName()).setSql(sql).setBatch(this.batch).setParams(this.getParams()));
    }

    @Override
    public int saveBatchMap(List<Map<String, Object>> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return 0;
        }
        this.interceptorChain.doBeforeSave(this.queryInfo, dataList);
        INbExecutor executor = this.newExecutor();
        return executor.insertBatch(this, dataList, this.getParams());
    }

    @Override
    public <F> F func(String funcName, ResultType type, boolean limit) {
        String sql = this.sqlBuilder.buildFuncSql(this, funcName, limit);
        INbExecutor executor = this.newExecutor();
        return (F)executor.doQuery(this.getDsName(), sql, this.getParams(), type);
    }

    @Override
    public int count(boolean page) {
        String countSql = "count(*)";
        if (this.expression.getGroupBy().isEmpty()) {
            return (Integer)this.func(countSql, ResultType.INT, page);
        }
        String sql = this.sqlBuilder.buildQuerySql(this, "1", page);
        String buildSql = StrUtil.format((CharSequence)"SELECT {} FROM ({}) tc", (Object[])new Object[]{countSql, sql});
        INbExecutor executor = this.newExecutor();
        return (Integer)executor.doQuery(this.getDsName(), buildSql, this.getParams(), ResultType.INT);
    }

    @Override
    public NbQuerier<T> conditionCount(ILaterQuerier laterQuerier, String alias, boolean coalesce) {
        ISqlSegment sqlSegment = BuildInFunc.count(() -> laterQuerier.getSqlSegment(this));
        if (coalesce) {
            sqlSegment = BuildInFunc.coalesce(this, sqlSegment, QueryValParam.intVal(0));
        }
        this.addConditionAgg(sqlSegment, alias);
        return this;
    }

    @Override
    public NbQuerier<T> addConditionAgg(ISqlSegment count, String alias) {
        this.safeGetConditionAggList().add(new ConditionAgg(count, alias));
        return this;
    }

    @Override
    public double sum(String field) {
        QueryItem queryItem = new QueryItem(field);
        QueryField one = BuildUtils.findOne(this.getQueryFields(), queryItem, this.queryInfo.getTableName(), this.tableAliasMap);
        Assert.notNull((Object)one, (String)"\u6c42\u548c\u5b57\u6bb5:[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{field});
        return (Double)this.func(StrUtil.format((CharSequence)"sum({})", (Object[])new Object[]{queryItem.getExpr()}), ResultType.DOUBLE, false);
    }

    @Override
    public boolean exist() {
        String sql = this.sqlBuilder.buildQuerySql(this, "1", false);
        sql = sql + " limit 1";
        INbExecutor executor = this.newExecutor();
        List list = (List)executor.doQuery(this.getDsName(), sql, this.getParams(), ResultType.LIST);
        return CollUtil.isNotEmpty((Collection)list);
    }

    @Override
    public List<LinkedHashMap<String, Object>> selectMapList() {
        this.interceptorChain.doQueryBefore(this.getQueryInfo());
        INbExecutor executor = this.newExecutor();
        return (List)executor.doQuery(this.getDsName(), this.buildQuerySql(), this.getParams(), ResultType.LIST);
    }

    @Override
    public boolean hasWhere() {
        return CollUtil.isNotEmpty((Collection)this.expression.getNormal());
    }

    @Override
    public NbQuerier<T> alias(String alias) {
        this.tableAliasMap.put((Object)this.queryInfo.getTableName(), (Object)alias);
        this.queryInfo.setAlias(alias);
        return this;
    }

    @Override
    public String buildConnect(NbQuerier<?> querier) {
        String sql = querier.buildQuerySql();
        return this.connectParam(querier, sql);
    }

    @Override
    public String connectParam(NbQuerier<?> querier, String sql) {
        List<QueryValParam> params = querier.getParams();
        if (CollUtil.isNotEmpty(params)) {
            for (int i = 0; i < params.size(); ++i) {
                QueryValParam param = params.get(i);
                String key = String.format("#{NB_PARAM_%s}", i);
                String replaceTo = this.formatVariable(param.getType(), param.getValue(), false);
                sql = StrUtil.replace((CharSequence)sql, (CharSequence)key, (CharSequence)replaceTo);
            }
        }
        return sql;
    }

    @Override
    public NbQuerier<T> withMany(String fieldName, NbQuerier<?> querier) {
        Assert.isTrue((this.config.getDbType() == DbType.POSTGRE_SQL || this.config.getDbType() == DbType.PG_NG ? 1 : 0) != 0, (String)"\u76ee\u524d\u53ea\u652f\u6301postgresql", (Object[])new Object[0]);
        if (querier != null) {
            String subSql = this.buildConnect(querier);
            String sql = StrUtil.format((CharSequence)"(select json_agg(tem) from ({}) tem) as {}", (Object[])new Object[]{subSql, fieldName});
            this.additionField(sql);
        }
        return this;
    }

    @Override
    public NbQuerier<T> withOne(String fieldName, NbQuerier<?> querier) {
        Assert.isTrue((this.config.getDbType() == DbType.POSTGRE_SQL || this.config.getDbType() == DbType.PG_NG ? 1 : 0) != 0, (String)"\u76ee\u524d\u53ea\u652f\u6301postgresql", (Object[])new Object[0]);
        if (querier != null) {
            String subSql = this.buildConnect(querier);
            QueryItem queryItem = new QueryItem(fieldName);
            String sql = StrUtil.format((CharSequence)"(select row_to_json(tem) from ({}) tem) as {}", (Object[])new Object[]{subSql, queryItem.getName()});
            this.additionField(sql);
        }
        return this;
    }

    @Override
    public NbQuerier<T> withManyCount(String fieldName, NbQuerier<?> querier) {
        switch (this.config.getDbType()) {
            case MYSQL: 
            case POSTGRE_SQL: {
                if (querier == null) break;
                querier.field("1");
                String subSql = this.buildConnect(querier);
                String sql = StrUtil.format((CharSequence)"(select count(1) from ({}) t) as {}", (Object[])new Object[]{subSql, StrUtil.toUnderlineCase((CharSequence)fieldName)});
                this.additionField(sql);
                break;
            }
            default: {
                throw new NbSQLException("\u6682\u4e0d\u652f\u6301withManyCount\u65b9\u6cd5", new Object[0]);
            }
        }
        return this;
    }

    @Override
    public NbQuerier<T> group(String ... columns) {
        if (ArrayUtil.isEmpty((Object[])columns)) {
            return this;
        }
        ArrayList<ISqlSegment> segments = new ArrayList<ISqlSegment>();
        segments.add(SqlKeyword.GROUP_BY);
        for (String column : columns) {
            segments.add(this.getColumnName(column, false));
        }
        ISqlSegment[] iSqlSegments = segments.toArray(new ISqlSegment[0]);
        this.expression.add(iSqlSegments);
        return this;
    }

    @Override
    public NbQuerier<T> autoOrder() {
        List<OrderInfo> orderInfos = this.queryInfo.getTable().getOrderInfos();
        if (CollUtil.isNotEmpty(orderInfos)) {
            for (OrderInfo orderInfo : orderInfos) {
                String fieldName = orderInfo.getNbField().getName();
                String tableName = orderInfo.getNbField().getTableName();
                if (StrUtil.isNotBlank((CharSequence)tableName)) {
                    fieldName = SqlUtils.withAlias((String)this.tableAliasMap.get((Object)tableName), fieldName);
                }
                this.order(orderInfo.getOrderType(), fieldName);
            }
        } else {
            INbField orderField = (INbField)CollUtil.findOne(this.getQueryInfo().getFields(), i -> i.getFieldType() == NbFieldType.ORDER);
            if (orderField != null) {
                this.order(NbOrderType.DESC, orderField.getName());
                return this;
            }
            IdType type = this.queryInfo.getPk().getType();
            if (type == IdType.AUTO || type == IdType.ASSIGN_ID) {
                this.desc(SqlUtils.withAlias(this.queryInfo.getAlias(), this.getPkName()));
            }
        }
        return this;
    }

    @Override
    public NbQuerier<T> updateExpr(String expr) {
        this.safeGetUpdateData().addExpr(expr);
        return this;
    }

    @Override
    public NbQuerier<T> updateExpr(String sql, Object ... params) {
        QueryValParam[] queryValParam = new QueryValParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof String) {
                queryValParam[i] = QueryValParam.stringVal((String)param);
                continue;
            }
            if (param instanceof Long) {
                queryValParam[i] = QueryValParam.longVal((Long)param);
                continue;
            }
            throw new NbSQLMessageException("\u672a\u5904\u7406\u8bbe\u7f6e\u8be5\u7c7b\u578b", new Object[0]);
        }
        return this.updateExpr(sql, queryValParam);
    }

    @Override
    public String parseSqlParam(String sql, QueryValParam ... params) {
        if (params.length == 0) {
            return sql;
        }
        int length = sql.length();
        StringBuilder builder = new StringBuilder(sql.length() + params.length * "#{NB_PARAM_%s}".length());
        int preIndex = 0;
        for (QueryValParam param : params) {
            String paramStr = this.paramBuilder.formatVariable(param.getType(), param.getValue(), true);
            int index = sql.indexOf("?", preIndex);
            Assert.isTrue((index > 0 ? 1 : 0) != 0, (String)"sql:{}\u5360\u4f4d\u7b26\u4e0d\u591f:{}", (Object[])new Object[]{params.length});
            builder.append(sql.subSequence(preIndex, index));
            builder.append(paramStr);
            preIndex = index + 1;
        }
        if (preIndex < length) {
            builder.append(sql.subSequence(preIndex, length));
        }
        return builder.toString();
    }

    @Override
    public NbQuerier<T> tableSchema(String schema) {
        this.queryInfo.setSchema(schema);
        return this;
    }

    @Override
    public String getDsName() {
        return this.getQueryInfo().getDs();
    }

    @Override
    public NbQuerier<T> lock() {
        return this.last("FOR UPDATE");
    }

    @Override
    public DbType getDbType() {
        return this.config.getDbType();
    }

    @Override
    public QueryField findField(String fieldName) {
        QueryField one = BuildUtils.findOne(this.queryFields, new QueryItem(fieldName), this.queryInfo.getTableName(), this.tableAliasMap);
        Assert.notNull((Object)one, (String)"\u8868:{},\u4e0d\u5b58\u5728\u5b57\u6bb5:{}", (Object[])new Object[]{this.getTableName(), fieldName});
        return one;
    }

    private QueryItem getColumnName(String column, boolean isOrder) {
        String alias;
        QueryItem queryItem = new QueryItem(column);
        QueryField queryField = BuildUtils.findOne(this.queryFields, queryItem, this.queryInfo.getTableName(), this.tableAliasMap);
        Assert.notNull((Object)queryField, (String)"\u8868\u5355:{}\u64cd\u4f5c\u5b57\u6bb5:{}\u4e0d\u5b58\u5728", (Object[])new Object[]{this.queryInfo.getTableName(), column});
        queryItem.setQueryField(queryField);
        String orderRedirect = queryField.getOrderRedirect();
        if (isOrder && StrUtil.isNotBlank((CharSequence)orderRedirect)) {
            queryItem.setName(orderRedirect);
            return queryItem;
        }
        if (StrUtil.isNotBlank((CharSequence)queryField.getRedirect())) {
            queryItem.setName(queryField.getRedirect());
        }
        if (StrUtil.isNotBlank((CharSequence)(alias = queryField.getTableName())) && this.tableAliasMap.containsKey((Object)alias)) {
            queryItem.setTableAlias((String)this.tableAliasMap.get((Object)alias));
        }
        return queryItem;
    }

    @Override
    public NbQuerier<T> additionFields(List<String> fields) {
        List<String> additionFields = this.getOrCreateAdditionFields();
        additionFields.addAll(fields);
        return this;
    }

    private List<String> getOrCreateAdditionFields() {
        List<String> additionFields = this.queryInfo.getAdditionFields();
        if (additionFields == null) {
            additionFields = new ArrayList<String>();
            this.queryInfo.setAdditionFields(additionFields);
        }
        return additionFields;
    }

    @Override
    public NbQuerier<T> additionField(String field) {
        List<String> additionFields = this.getOrCreateAdditionFields();
        if (!additionFields.contains(field)) {
            additionFields.add(field);
        }
        return this;
    }

    public <F> F find(Class<F> clazz) {
        LinkedHashMap<String, Object> map = this.findMap(true);
        if (map == null) {
            return null;
        }
        Assert.notNull(clazz, (String)"find \u65b9\u6cd5class\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.mapToBean(map, clazz);
    }

    @Override
    public T find() {
        T t = this.find(this.resultClass);
        List<Consumer<T>> consumers = this.resultConsumer.getDoAfterForItemConsumers();
        if (t != null && CollUtil.isNotEmpty(consumers)) {
            for (Consumer<T> consumer : consumers) {
                consumer.accept(t);
            }
        }
        return t;
    }

    @Override
    public LinkedHashMap<String, Object> selectOne(boolean assertOne) {
        List<LinkedHashMap<String, Object>> maps = this.selectMap();
        if (assertOne) {
            Assert.isTrue((maps.size() <= 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u4e00\u4e2a", (Object[])new Object[0]);
        }
        LinkedHashMap<String, Object> map = null;
        if (CollUtil.isNotEmpty(maps)) {
            this.resultConsumer.doMapList(maps);
            map = maps.get(0);
            if (map != null) {
                this.resultConsumer.doMap(map);
            }
        }
        return map;
    }

    @Override
    public NbQuerier<T> doAfterForMapList(Consumer<List<LinkedHashMap<String, Object>>> doAfter) {
        this.resultConsumer.doAfterForMapList(doAfter);
        return this;
    }

    @Override
    public NbQuerier<T> doAfterForItem(Consumer<T> doAfterForItem) {
        this.resultConsumer.doAfterForItem(doAfterForItem);
        return this;
    }

    @Override
    public NbQuerier<T> doAfterForItemMap(Consumer<LinkedHashMap<String, Object>> doAfterForItemMap) {
        this.resultConsumer.doAfterForItemMap(doAfterForItemMap);
        return this;
    }

    @Override
    public NbQuerier<T> doAfterForList(Consumer<List<T>> doAfter) {
        this.resultConsumer.doAfterForList(doAfter);
        return this;
    }

    @Override
    public String getSqlSegment() {
        String sql = this.expression.getSqlSegment();
        if (StrUtil.isNotBlank((CharSequence)this.lastSql)) {
            sql = sql + this.lastSql;
        }
        return sql;
    }

    @Override
    public Map<String, Object> beanToMap(T bean) {
        Map map = BeanUtil.beanToMap(bean, (boolean)true, (boolean)false);
        if (this.queryInfo.isClass()) {
            this.mapFieldAlias(map, true);
            Set keys = map.keySet();
            ArrayList<String> removes = new ArrayList<String>();
            for (String key : keys) {
                if (this.findQueryField(key) != null) continue;
                removes.add(key);
            }
            if (CollUtil.isNotEmpty(removes)) {
                removes.forEach(map::remove);
            }
        }
        return map;
    }

    public INbSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public INbQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public NbQuerierProperties getConfig() {
        return this.config;
    }

    public NbInterceptorRegistry getInterceptorChain() {
        return this.interceptorChain;
    }

    public IDialectWare getDialectWare() {
        return this.dialectWare;
    }

    public NbQuerierConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public NbQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public INbExecuteBatch getBatch() {
        return this.batch;
    }

    @Override
    public Class<T> getResultClass() {
        return this.resultClass;
    }

    @Override
    public List<JoinTableRule> getJoins() {
        return this.joins;
    }

    @Override
    public List<ConditionAgg> getConditionAggList() {
        return this.conditionAggList;
    }

    @Override
    public QueryFields getQueryFields() {
        return this.queryFields;
    }

    public ParamBuilder getParamBuilder() {
        return this.paramBuilder;
    }

    @Override
    public MergeSegments getExpression() {
        return this.expression;
    }

    public String getLastSql() {
        return this.lastSql;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public INbTransaction getTx() {
        return this.tx;
    }

    public ResultConsumer<T> getResultConsumer() {
        return this.resultConsumer;
    }

    @Override
    public BiMap<String, String> getTableAliasMap() {
        return this.tableAliasMap;
    }

    public UpdateData getUpdateData() {
        return this.updateData;
    }

    public DefaultNbQuerier<T> setBatch(INbExecuteBatch batch) {
        this.batch = batch;
        return this;
    }

    @Override
    public DefaultNbQuerier<T> setResultClass(Class<T> resultClass) {
        this.resultClass = resultClass;
        return this;
    }

    public DefaultNbQuerier<T> setConditionAggList(List<ConditionAgg> conditionAggList) {
        this.conditionAggList = conditionAggList;
        return this;
    }

    public DefaultNbQuerier<T> setQueryFields(QueryFields queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    public DefaultNbQuerier<T> setParamBuilder(ParamBuilder paramBuilder) {
        this.paramBuilder = paramBuilder;
        return this;
    }

    public DefaultNbQuerier<T> setExpression(MergeSegments expression) {
        this.expression = expression;
        return this;
    }

    public DefaultNbQuerier<T> setLastSql(String lastSql) {
        this.lastSql = lastSql;
        return this;
    }

    @Override
    public DefaultNbQuerier<T> setTx(INbTransaction tx) {
        this.tx = tx;
        return this;
    }

    public DefaultNbQuerier<T> setResultConsumer(ResultConsumer<T> resultConsumer) {
        this.resultConsumer = resultConsumer;
        return this;
    }

    public DefaultNbQuerier<T> setTableAliasMap(BiMap<String, String> tableAliasMap) {
        this.tableAliasMap = tableAliasMap;
        return this;
    }

    public DefaultNbQuerier<T> setUpdateData(UpdateData updateData) {
        this.updateData = updateData;
        return this;
    }

    public String formatVariable(NbQueryType type, Object value) {
        return this.getParamBuilder().formatVariable(type, value);
    }

    @Override
    public String formatVariable(INbQueryType type, Object value, boolean update) {
        return this.getParamBuilder().formatVariable(type, value, update);
    }

    @Override
    public String formatVariable(QueryValParam param) {
        return this.getParamBuilder().formatVariable(param);
    }

    @Override
    public String formatVariable(INbQueryType type, Object value, boolean update, boolean toArray) {
        return this.getParamBuilder().formatVariable(type, value, update, toArray);
    }

    public LinkedList<QueryValParam> getParams() {
        return this.getParamBuilder().getParams();
    }

    public AtomicInteger getParamIndex() {
        return this.getParamBuilder().getParamIndex();
    }
}

