/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata.custom;

import cn.hperfect.nbquerier.annotation.NbField;
import cn.hperfect.nbquerier.core.json.serializer.CustomEntityJsonSerializer;
import cn.hperfect.nbquerier.core.metedata.custom.RemoveValueMapProvider;
import cn.hperfect.nbquerier.toolkit.map.UnderlineCaseMap;
import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.BasicTypeGetter;
import cn.hutool.core.map.CamelCaseMap;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize(using=CustomEntityJsonSerializer.class)
public abstract class BaseCustomEntity
implements BasicTypeGetter<String>,
Serializable,
Map<String, Object> {
    public static final String CUSTOM_FIELD_DATA_KEY = "_customFieldData";
    @NbField(exist=false)
    public final transient Map<String, Object> _customFieldData;
    @NbField(exist=false)
    private final transient BeanDesc _beanDesc;
    @NbField(exist=false)
    private transient Set<Map.Entry<String, Object>> _entrySet;
    @NbField(exist=false)
    public transient Set<String> _removeKeySet = new HashSet<String>();
    @NbField(exist=false)
    private transient int _size;

    protected BaseCustomEntity() {
        this._customFieldData = new HashMap<String, Object>();
        this._beanDesc = BeanUtil.getBeanDesc(this.getClass());
        this._size = this.getProps().size();
    }

    protected BaseCustomEntity(RemoveValueMapProvider provider) {
        this();
        this.initByProvider(provider);
    }

    protected void initByMap(Map<String, Object> map) {
        this.initByProvider(new RemoveValueMapProvider((Map<String, Object>)new CamelCaseMap(map)));
    }

    protected void initByProvider(RemoveValueMapProvider provider) {
        BeanUtil.fillBeanWithMap((Map)provider, (Object)this, (boolean)false, (CopyOptions)new CopyOptions());
        this._size += provider.size();
        this._customFieldData.putAll(provider);
    }

    protected BaseCustomEntity(Map<String, Object> data) {
        this(data instanceof RemoveValueMapProvider ? (RemoveValueMapProvider)data : new RemoveValueMapProvider((Map<String, Object>)new CamelCaseMap(data)));
    }

    public final void set(String fieldName, Object value) {
        PropDesc prop = this._beanDesc.getProp(StrUtil.toCamelCase((CharSequence)fieldName));
        if (prop != null) {
            Type valueType = prop.getFieldType();
            prop.setValue((Object)this, Convert.convertWithCheck((Type)valueType, (Object)value, null, (boolean)false));
        } else {
            this._customFieldData.put(fieldName, value);
        }
    }

    public final <T> T get(String fieldName) throws BeanException {
        return this.get(fieldName, false);
    }

    public final <T> T get(String fieldName, boolean toCamelCase) throws BeanException {
        PropDesc prop;
        if (toCamelCase) {
            fieldName = StrUtil.toCamelCase((CharSequence)fieldName);
        }
        if ((prop = BeanUtil.getBeanDesc(this.getClass()).getProp(fieldName)) != null) {
            return (T)prop.getGetter().invoke((Object)this, new Object[0]);
        }
        return (T)this._customFieldData.get(fieldName);
    }

    public final Map<String, Object> getDataMap() {
        Map map = BeanUtil.beanToMap((Object)this, (boolean)false, (boolean)true);
        Map newMap = (Map)map.remove("_custom_field_data");
        if (newMap != null) {
            map.putAll(newMap);
        }
        return map;
    }

    public Map<String, Object> getReadOnlyDataUnderlineCaseMap() {
        return Collections.unmodifiableMap(new UnderlineCaseMap<Object>(this));
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        throw new RuntimeException("\u4e3a\u5b9e\u73b0\u5462");
    }

    @Override
    public final Set<String> keySet() {
        Set keySet = this._beanDesc.getPropMap(false).keySet();
        keySet.addAll(this._customFieldData.keySet());
        return Collections.unmodifiableSet(keySet);
    }

    public Object getObj(String key) {
        return this.get(key);
    }

    public String getStr(String key) {
        return Convert.toStr(this.get(key));
    }

    public Integer getInt(String key) {
        return Convert.toInt(this.get(key));
    }

    public Short getShort(String key) {
        return Convert.toShort(this.get(key));
    }

    public Boolean getBool(String key) {
        return Convert.toBool(this.get(key));
    }

    public Long getLong(String key) {
        return Convert.toLong(this.get(key));
    }

    public Character getChar(String key) {
        return Convert.toChar(this.get(key));
    }

    public Float getFloat(String key) {
        return Convert.toFloat(this.get(key));
    }

    public Double getDouble(String key) {
        return Convert.toDouble(this.get(key));
    }

    public Byte getByte(String key) {
        return Convert.toByte(this.get(key));
    }

    public BigDecimal getBigDecimal(String key) {
        return Convert.toBigDecimal(this.get(key));
    }

    public BigInteger getBigInteger(String key) {
        return Convert.toBigInteger(this.get(key));
    }

    public Map<String, Object> getMap(String key) {
        return Convert.toMap(String.class, Object.class, this.get(key));
    }

    public <T> T getBean(String name, Class<T> clazz) {
        return (T)BeanUtil.toBean(this.get(name), clazz);
    }

    public Date getDate(String key) {
        return Convert.toDate(this.get(key));
    }

    @Override
    @Deprecated
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        throw new RuntimeException("\u4e3a\u5b9e\u73b0containsKey");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("\u4e3a\u5b9e\u73b0containsValue");
    }

    @Override
    public Object get(Object key) {
        return this.get(Convert.toStr((Object)key), true);
    }

    @Override
    public Object put(String key, Object value) {
        this.set(key, value);
        return value;
    }

    private void resize() {
    }

    @Override
    public Object remove(Object key) {
        String keyStr = StrUtil.toCamelCase((CharSequence)((String)key));
        PropDesc prop = this._beanDesc.getProp(keyStr);
        if (prop != null) {
            Object value = prop.getGetter().invoke((Object)this, new Object[0]);
            if (!this._removeKeySet.contains(keyStr)) {
                this._removeKeySet.add(keyStr);
                --this._size;
            }
            if (value != null) {
                prop.getSetter().invoke((Object)this, new Object[]{null});
            }
            return value;
        }
        return this._customFieldData.remove(keyStr);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        throw new RuntimeException("\u4e3a\u5b9e\u73b0clear");
    }

    @Override
    public Collection<Object> values() {
        Set<PropDesc> props = this.getProps();
        ArrayList<Object> values = new ArrayList<Object>(this._customFieldData.values());
        for (PropDesc prop : props) {
            values.add(prop.getGetter().invoke((Object)this, new Object[0]));
        }
        return values;
    }

    private Set<PropDesc> getProps() {
        return this._beanDesc.getProps().stream().filter(i -> !StrUtil.startWith((CharSequence)i.getFieldName(), (CharSequence)"_")).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> es = new HashSet<Map.Entry<String, Object>>(this._customFieldData.entrySet());
        for (PropDesc prop : this.getProps()) {
            Object value = prop.getGetter().invoke((Object)this, new Object[0]);
            Node node = new Node(prop.getFieldName(), value, null);
            es.add(node);
        }
        return es;
    }

    public Map<String, Object> get_customFieldData() {
        return this._customFieldData;
    }

    public BeanDesc get_beanDesc() {
        return this._beanDesc;
    }

    public Set<String> get_removeKeySet() {
        return this._removeKeySet;
    }

    public int get_size() {
        return this._size;
    }

    public void set_entrySet(Set<Map.Entry<String, Object>> _entrySet) {
        this._entrySet = _entrySet;
    }

    public void set_removeKeySet(Set<String> _removeKeySet) {
        this._removeKeySet = _removeKeySet;
    }

    public void set_size(int _size) {
        this._size = _size;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCustomEntity)) {
            return false;
        }
        BaseCustomEntity other = (BaseCustomEntity)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCustomEntity;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BaseCustomEntity(_customFieldData=" + this.get_customFieldData() + ", _beanDesc=" + this.get_beanDesc() + ", _entrySet=" + this._entrySet + ", _removeKeySet=" + this.get_removeKeySet() + ", _size=" + this.get_size() + ")";
    }

    static class TestEntity
    extends BaseCustomEntity {
        private String name;
        private String name2;
        private String nameTest;

        public String getName() {
            return this.name;
        }

        public String getName2() {
            return this.name2;
        }

        public String getNameTest() {
            return this.nameTest;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setName2(String name2) {
            this.name2 = name2;
        }

        public void setNameTest(String nameTest) {
            this.nameTest = nameTest;
        }

        @Override
        public String toString() {
            return "BaseCustomEntity.TestEntity(name=" + this.getName() + ", name2=" + this.getName2() + ", nameTest=" + this.getNameTest() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestEntity)) {
                return false;
            }
            TestEntity other = (TestEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$name2 = this.getName2();
            String other$name2 = other.getName2();
            if (this$name2 == null ? other$name2 != null : !this$name2.equals(other$name2)) {
                return false;
            }
            String this$nameTest = this.getNameTest();
            String other$nameTest = other.getNameTest();
            return !(this$nameTest == null ? other$nameTest != null : !this$nameTest.equals(other$nameTest));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TestEntity;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $name2 = this.getName2();
            result = result * 59 + ($name2 == null ? 43 : $name2.hashCode());
            String $nameTest = this.getNameTest();
            result = result * 59 + ($nameTest == null ? 43 : $nameTest.hashCode());
            return result;
        }
    }

    static class Node
    implements Map.Entry<String, Object> {
        final String key;
        Object value;
        Node next;

        Node(String key, Object value, Node next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public Object setValue(Object value) {
            this.value = value;
            return value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public Node getNext() {
            return this.next;
        }

        public void setNext(Node next) {
            this.next = next;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Node this$next = this.getNext();
            Node other$next = other.getNext();
            return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Node $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
            return result;
        }
    }

    abstract class HashIterator {
        Node next;
        Node current = new Node("535", "1", new Node("1", "4", null));
        int expectedModCount;
        int index;
        final int size;

        HashIterator() {
            this.next = this.current.getNext();
            this.size = BaseCustomEntity.this.size();
        }

        public final boolean hasNext() {
            return this.index < this.size;
        }

        final Node nextNode() {
            this.next = this.current.getNext();
            return this.next;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<String, Object>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<String, Object> next() {
            return this.nextNode();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return BaseCustomEntity.this.size();
        }
    }
}

