/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.querier.IResultMap;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class ResultConsumer<T>
implements IResultMap<T> {
    private Consumer<List<T>> doAfterForList;
    private List<Consumer<T>> doAfterForItemConsumers;
    private List<Consumer<LinkedHashMap<String, Object>>> doAfterForItemMapConsumers;
    private List<Consumer<List<LinkedHashMap<String, Object>>>> doAfterForMapListConsumers;

    public void doMapList(List<LinkedHashMap<String, Object>> resultList) {
        if (CollUtil.isNotEmpty(this.doAfterForMapListConsumers)) {
            for (Consumer<List<LinkedHashMap<String, Object>>> consumer : this.doAfterForMapListConsumers) {
                consumer.accept(resultList);
            }
        }
        if (CollUtil.isNotEmpty(this.doAfterForItemMapConsumers)) {
            for (Consumer<Object> consumer : this.doAfterForItemMapConsumers) {
                resultList.forEach(consumer);
            }
        }
    }

    public void doBeanList(List<T> list) {
        if (this.doAfterForList != null) {
            this.doAfterForList.accept(list);
        }
        if (CollUtil.isNotEmpty(this.doAfterForItemConsumers)) {
            for (Consumer<T> tConsumer : this.doAfterForItemConsumers) {
                list.forEach(tConsumer);
            }
        }
    }

    @Override
    public NbQuerier<T> doAfterForMapList(Consumer<List<LinkedHashMap<String, Object>>> doAfter) {
        if (this.doAfterForMapListConsumers == null) {
            this.doAfterForMapListConsumers = new ArrayList<Consumer<List<LinkedHashMap<String, Object>>>>();
        }
        this.doAfterForMapListConsumers.add(doAfter);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForItem(Consumer<T> doAfterForItem) {
        if (this.doAfterForItemConsumers == null) {
            this.doAfterForItemConsumers = new ArrayList<Consumer<T>>();
        }
        this.doAfterForItemConsumers.add(doAfterForItem);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForItemMap(Consumer<LinkedHashMap<String, Object>> doAfterForItemMap) {
        if (this.doAfterForItemMapConsumers == null) {
            this.doAfterForItemMapConsumers = new ArrayList<Consumer<LinkedHashMap<String, Object>>>();
        }
        this.doAfterForItemMapConsumers.add(doAfterForItemMap);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForList(Consumer<List<T>> doAfter) {
        this.doAfterForList = doAfter;
        return null;
    }

    public void doMap(LinkedHashMap<String, Object> map) {
        if (CollUtil.isNotEmpty(this.doAfterForItemMapConsumers)) {
            for (Consumer<LinkedHashMap<String, Object>> doAfterForItemMapConsumer : this.doAfterForItemMapConsumers) {
                doAfterForItemMapConsumer.accept(map);
            }
        }
    }

    public Consumer<List<T>> getDoAfterForList() {
        return this.doAfterForList;
    }

    public List<Consumer<T>> getDoAfterForItemConsumers() {
        return this.doAfterForItemConsumers;
    }

    public List<Consumer<LinkedHashMap<String, Object>>> getDoAfterForItemMapConsumers() {
        return this.doAfterForItemMapConsumers;
    }

    public List<Consumer<List<LinkedHashMap<String, Object>>>> getDoAfterForMapListConsumers() {
        return this.doAfterForMapListConsumers;
    }

    public void setDoAfterForList(Consumer<List<T>> doAfterForList) {
        this.doAfterForList = doAfterForList;
    }

    public void setDoAfterForItemConsumers(List<Consumer<T>> doAfterForItemConsumers) {
        this.doAfterForItemConsumers = doAfterForItemConsumers;
    }

    public void setDoAfterForItemMapConsumers(List<Consumer<LinkedHashMap<String, Object>>> doAfterForItemMapConsumers) {
        this.doAfterForItemMapConsumers = doAfterForItemMapConsumers;
    }

    public void setDoAfterForMapListConsumers(List<Consumer<List<LinkedHashMap<String, Object>>>> doAfterForMapListConsumers) {
        this.doAfterForMapListConsumers = doAfterForMapListConsumers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultConsumer)) {
            return false;
        }
        ResultConsumer other = (ResultConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Consumer<List<T>> this$doAfterForList = this.getDoAfterForList();
        Consumer<List<T>> other$doAfterForList = other.getDoAfterForList();
        if (this$doAfterForList == null ? other$doAfterForList != null : !this$doAfterForList.equals(other$doAfterForList)) {
            return false;
        }
        List<Consumer<T>> this$doAfterForItemConsumers = this.getDoAfterForItemConsumers();
        List<Consumer<T>> other$doAfterForItemConsumers = other.getDoAfterForItemConsumers();
        if (this$doAfterForItemConsumers == null ? other$doAfterForItemConsumers != null : !((Object)this$doAfterForItemConsumers).equals(other$doAfterForItemConsumers)) {
            return false;
        }
        List<Consumer<LinkedHashMap<String, Object>>> this$doAfterForItemMapConsumers = this.getDoAfterForItemMapConsumers();
        List<Consumer<LinkedHashMap<String, Object>>> other$doAfterForItemMapConsumers = other.getDoAfterForItemMapConsumers();
        if (this$doAfterForItemMapConsumers == null ? other$doAfterForItemMapConsumers != null : !((Object)this$doAfterForItemMapConsumers).equals(other$doAfterForItemMapConsumers)) {
            return false;
        }
        List<Consumer<List<LinkedHashMap<String, Object>>>> this$doAfterForMapListConsumers = this.getDoAfterForMapListConsumers();
        List<Consumer<List<LinkedHashMap<String, Object>>>> other$doAfterForMapListConsumers = other.getDoAfterForMapListConsumers();
        return !(this$doAfterForMapListConsumers == null ? other$doAfterForMapListConsumers != null : !((Object)this$doAfterForMapListConsumers).equals(other$doAfterForMapListConsumers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultConsumer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Consumer<List<T>> $doAfterForList = this.getDoAfterForList();
        result = result * 59 + ($doAfterForList == null ? 43 : $doAfterForList.hashCode());
        List<Consumer<T>> $doAfterForItemConsumers = this.getDoAfterForItemConsumers();
        result = result * 59 + ($doAfterForItemConsumers == null ? 43 : ((Object)$doAfterForItemConsumers).hashCode());
        List<Consumer<LinkedHashMap<String, Object>>> $doAfterForItemMapConsumers = this.getDoAfterForItemMapConsumers();
        result = result * 59 + ($doAfterForItemMapConsumers == null ? 43 : ((Object)$doAfterForItemMapConsumers).hashCode());
        List<Consumer<List<LinkedHashMap<String, Object>>>> $doAfterForMapListConsumers = this.getDoAfterForMapListConsumers();
        result = result * 59 + ($doAfterForMapListConsumers == null ? 43 : ((Object)$doAfterForMapListConsumers).hashCode());
        return result;
    }

    public String toString() {
        return "ResultConsumer(doAfterForList=" + this.getDoAfterForList() + ", doAfterForItemConsumers=" + this.getDoAfterForItemConsumers() + ", doAfterForItemMapConsumers=" + this.getDoAfterForItemMapConsumers() + ", doAfterForMapListConsumers=" + this.getDoAfterForMapListConsumers() + ")";
    }
}

