/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.metedata.QueryField;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;

public class QueryFields {
    Map<String, Set<QueryField>> fieldsMap = new HashMap<String, Set<QueryField>>();
    List<QueryField> fields = null;

    public QueryFields() {
    }

    public QueryFields(Collection<QueryField> fields) {
        this.puts(fields);
    }

    public Collection<QueryField> fields() {
        if (this.fields == null) {
            this.fields = this.fieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return this.fields;
    }

    public void puts(Collection<QueryField> fields) {
        if (CollUtil.isNotEmpty(fields)) {
            for (QueryField field : fields) {
                Set<QueryField> queryFields = this.ifAbsentCreate(field.getName());
                queryFields.add(field);
            }
        }
    }

    private Set<QueryField> ifAbsentCreate(String name) {
        return this.fieldsMap.computeIfAbsent(name, k -> new HashSet());
    }

    public Collection<QueryField> findByName(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    public void puts(QueryFields queryFields) {
        queryFields.fieldsMap.forEach((k, v) -> this.ifAbsentCreate((String)k).addAll((Collection<QueryField>)v));
    }

    @Nullable
    public QueryField find(String name, String table) {
        Set<QueryField> queryFields = this.fieldsMap.get(name);
        if (CollUtil.isNotEmpty(queryFields)) {
            for (QueryField queryField : queryFields) {
                if (!StrUtil.equals((CharSequence)table, (CharSequence)queryField.getTableName())) continue;
                return queryField;
            }
        }
        return null;
    }

    public void add(QueryField queryField) {
        this.ifAbsentCreate(queryField.getName()).add(queryField);
    }
}

