/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.metedata.PageInfo;
import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.core.metedata.QueryFields;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.metedata.table.VirtualTable;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.enums.perm.PermType;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.List;

public class NbQueryInfo {
    private DbType dbType;
    private String sql;
    private INbTable table;
    private VirtualTable virtualTable;
    private QueryFields queryFields = new QueryFields();
    private String alias;
    private String setField;
    private List<String> additionFields;
    private List<String> excludeFields;
    private boolean withDelete;
    private boolean buildDelete;
    private boolean isClass;
    private boolean fieldReplace = true;
    private PageInfo pageInfo;
    private Object permValue;
    private List<Object> dataScope;
    private boolean ignoreDataScope;
    private boolean buildDataScope;
    private String schema;
    private boolean allowSetNull = false;
    private QueryType queryType;
    private String ds;
    private List<NbQuerier<?>> unionAllQueries;
    private NbQuerier<?> fromQuerier;
    private boolean validate = false;

    public PrimaryKey getPk() {
        INbTable nbTable = this.getTable();
        if (nbTable != null) {
            return nbTable.getPk();
        }
        return null;
    }

    public INbTable getTable() {
        if (this.isSub()) {
            return this.virtualTable;
        }
        Assert.notNull((Object)this.table, (String)"\u8868\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.table;
    }

    public String getPkName() {
        PrimaryKey pk = this.getPk();
        Assert.notNull((Object)pk, (String)"\u8868:{}\u4e3b\u952e\u4e0d\u5b58\u5728", (Object[])new Object[]{this.getTableName()});
        return pk.getName();
    }

    public String getTableName() {
        INbTable table = this.getTable();
        if (table != null) {
            return table.getTableName();
        }
        return null;
    }

    public boolean isSub() {
        return this.queryType != null && this.queryType == QueryType.SUB;
    }

    public boolean isSoftDelete() {
        return !this.withDelete && this.table.getDeleteField() != null;
    }

    public INbField findField(String field) {
        return (INbField)CollUtil.findOne(this.table.getFields(), i -> field.equals(i.getName()));
    }

    public boolean querySoftDelete() {
        return false;
    }

    public List<? extends INbField> getFields() {
        Assert.isFalse((boolean)this.isSub(), (String)"\u4e0d\u652f\u6301\u83b7\u53d6\u5b50\u67e5\u8be2\u5b57\u6bb5", (Object[])new Object[0]);
        return this.table.getFields();
    }

    public String getSchemaTable(boolean useReplace) {
        String tableName = useReplace && StrUtil.isNotBlank((CharSequence)this.table.getReplaceTable()) ? this.table.getReplaceTable() : this.getTableName();
        return SqlUtils.withAlias(this.getSchema(), tableName);
    }

    public INbField getDeleteField() {
        return this.table.getDeleteField();
    }

    public INbField getPermField() {
        INbTable table = this.getTable();
        if (table != null) {
            return table.getPermField();
        }
        return null;
    }

    public PermType getPermType() {
        if (this.queryType == QueryType.FORM_QUERY) {
            return PermType.ALL;
        }
        INbTable table = this.getTable();
        if (table != null) {
            return table.getPermType();
        }
        return null;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getSql() {
        return this.sql;
    }

    public VirtualTable getVirtualTable() {
        return this.virtualTable;
    }

    public QueryFields getQueryFields() {
        return this.queryFields;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSetField() {
        return this.setField;
    }

    public List<String> getAdditionFields() {
        return this.additionFields;
    }

    public List<String> getExcludeFields() {
        return this.excludeFields;
    }

    public boolean isWithDelete() {
        return this.withDelete;
    }

    public boolean isBuildDelete() {
        return this.buildDelete;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isFieldReplace() {
        return this.fieldReplace;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public Object getPermValue() {
        return this.permValue;
    }

    public List<Object> getDataScope() {
        return this.dataScope;
    }

    public boolean isIgnoreDataScope() {
        return this.ignoreDataScope;
    }

    public boolean isBuildDataScope() {
        return this.buildDataScope;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isAllowSetNull() {
        return this.allowSetNull;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public String getDs() {
        return this.ds;
    }

    public List<NbQuerier<?>> getUnionAllQueries() {
        return this.unionAllQueries;
    }

    public NbQuerier<?> getFromQuerier() {
        return this.fromQuerier;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTable(INbTable table) {
        this.table = table;
    }

    public void setVirtualTable(VirtualTable virtualTable) {
        this.virtualTable = virtualTable;
    }

    public void setQueryFields(QueryFields queryFields) {
        this.queryFields = queryFields;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSetField(String setField) {
        this.setField = setField;
    }

    public void setAdditionFields(List<String> additionFields) {
        this.additionFields = additionFields;
    }

    public void setExcludeFields(List<String> excludeFields) {
        this.excludeFields = excludeFields;
    }

    public void setWithDelete(boolean withDelete) {
        this.withDelete = withDelete;
    }

    public void setBuildDelete(boolean buildDelete) {
        this.buildDelete = buildDelete;
    }

    public void setClass(boolean isClass) {
        this.isClass = isClass;
    }

    public void setFieldReplace(boolean fieldReplace) {
        this.fieldReplace = fieldReplace;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public void setPermValue(Object permValue) {
        this.permValue = permValue;
    }

    public void setDataScope(List<Object> dataScope) {
        this.dataScope = dataScope;
    }

    public void setIgnoreDataScope(boolean ignoreDataScope) {
        this.ignoreDataScope = ignoreDataScope;
    }

    public void setBuildDataScope(boolean buildDataScope) {
        this.buildDataScope = buildDataScope;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setAllowSetNull(boolean allowSetNull) {
        this.allowSetNull = allowSetNull;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public void setDs(String ds) {
        this.ds = ds;
    }

    public void setUnionAllQueries(List<NbQuerier<?>> unionAllQueries) {
        this.unionAllQueries = unionAllQueries;
    }

    public void setFromQuerier(NbQuerier<?> fromQuerier) {
        this.fromQuerier = fromQuerier;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

