/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.metedata.INbExecuteBatch;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.exceptions.NbSQLExecuteException;
import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NbExecuteBatch
implements INbExecuteBatch {
    private final int batchSize;
    private int currSize = 0;
    private INbTransaction tx;
    private PreparedStatement preparedStatement;
    private List<int[]> results = new ArrayList<int[]>();

    public NbExecuteBatch(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void setPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        this.preparedStatement = preparedStatement;
    }

    @Override
    public void commit() throws SQLException {
        if (this.tx != null) {
            this.tx.commit();
            IoUtil.close((Closeable)this.tx);
        }
        IoUtil.close((AutoCloseable)this.preparedStatement);
    }

    @Override
    public INbTransaction getTx(NbQuerierConfiguration configuration) {
        if (this.tx != null) {
            return this.tx;
        }
        this.tx = configuration.newTx();
        return this.tx;
    }

    @Override
    public void addBatch() throws SQLException {
        ++this.currSize;
        this.preparedStatement.addBatch();
        if (this.batchSize > 0 && this.currSize >= this.batchSize) {
            this.executeBatch();
        }
    }

    private void executeBatch() throws SQLException {
        this.results.add(this.preparedStatement.executeBatch());
        this.currSize = 0;
    }

    @Override
    public void finish() {
        try {
            if (this.currSize > 0) {
                this.executeBatch();
            }
            this.commit();
        }
        catch (SQLException e) {
            throw new NbSQLExecuteException(e);
        }
        finally {
            IoUtil.close((Closeable)this);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tx != null) {
            this.tx.close();
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getCurrSize() {
        return this.currSize;
    }

    @Override
    public INbTransaction getTx() {
        return this.tx;
    }

    @Override
    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public List<int[]> getResults() {
        return this.results;
    }

    public void setCurrSize(int currSize) {
        this.currSize = currSize;
    }

    @Override
    public void setTx(INbTransaction tx) {
        this.tx = tx;
    }

    public void setResults(List<int[]> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NbExecuteBatch)) {
            return false;
        }
        NbExecuteBatch other = (NbExecuteBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getCurrSize() != other.getCurrSize()) {
            return false;
        }
        INbTransaction this$tx = this.getTx();
        INbTransaction other$tx = other.getTx();
        if (this$tx == null ? other$tx != null : !this$tx.equals(other$tx)) {
            return false;
        }
        PreparedStatement this$preparedStatement = this.getPreparedStatement();
        PreparedStatement other$preparedStatement = other.getPreparedStatement();
        if (this$preparedStatement == null ? other$preparedStatement != null : !this$preparedStatement.equals(other$preparedStatement)) {
            return false;
        }
        List<int[]> this$results = this.getResults();
        List<int[]> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NbExecuteBatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getCurrSize();
        INbTransaction $tx = this.getTx();
        result = result * 59 + ($tx == null ? 43 : $tx.hashCode());
        PreparedStatement $preparedStatement = this.getPreparedStatement();
        result = result * 59 + ($preparedStatement == null ? 43 : $preparedStatement.hashCode());
        List<int[]> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "NbExecuteBatch(batchSize=" + this.getBatchSize() + ", currSize=" + this.getCurrSize() + ", tx=" + this.getTx() + ", preparedStatement=" + this.getPreparedStatement() + ", results=" + this.getResults() + ")";
    }
}

