/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.conditions.segments;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.toolkit.StringPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractISegmentList
extends ArrayList<ISqlSegment>
implements ISqlSegment,
StringPool {
    ISqlSegment lastValue = null;
    boolean flushLastValue = false;
    private String sqlSegment = "";
    private boolean cacheSqlSegment = true;

    @Override
    public boolean addAll(Collection<? extends ISqlSegment> c) {
        ArrayList<ISqlSegment> list = new ArrayList<ISqlSegment>(c);
        boolean goon = this.transformList(list, (ISqlSegment)list.get(0), (ISqlSegment)list.get(list.size() - 1));
        if (goon) {
            this.cacheSqlSegment = false;
            if (this.flushLastValue) {
                this.flushLastValue(list);
            }
            return super.addAll(list);
        }
        return false;
    }

    protected abstract boolean transformList(List<ISqlSegment> var1, ISqlSegment var2, ISqlSegment var3);

    private void flushLastValue(List<ISqlSegment> list) {
        this.lastValue = list.get(list.size() - 1);
    }

    void removeAndFlushLast() {
        this.remove(this.size() - 1);
        this.flushLastValue(this);
    }

    @Override
    public String getSqlSegment() {
        if (this.cacheSqlSegment) {
            return this.sqlSegment;
        }
        this.cacheSqlSegment = true;
        this.sqlSegment = this.childrenSqlSegment();
        return this.sqlSegment;
    }

    protected abstract String childrenSqlSegment();

    @Override
    public void clear() {
        super.clear();
        this.lastValue = null;
        this.sqlSegment = "";
        this.cacheSqlSegment = true;
    }
}

