/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.type;

import cn.hperfect.nbquerier.core.components.convertor.BoolTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.DateTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.DecimalConvertor;
import cn.hperfect.nbquerier.core.components.convertor.DoubleTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.EnumTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.FloatTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.ITypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.IntListTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.IntTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.LongListTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.LongTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.MapEnumConvertor;
import cn.hperfect.nbquerier.core.components.convertor.NoTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.TextListTypeConvertor;
import cn.hperfect.nbquerier.core.components.convertor.TextTypeConvertor;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import cn.hperfect.nbquerier.enums.DbDataType;
import cn.hperfect.nbquerier.enums.INbEnum;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NbQueryType
extends Enum<NbQueryType>
implements INbQueryType {
    public static final /* enum */ NbQueryType TEXT = new NbQueryType(null, TextTypeConvertor.INSTANCE, "text", STRING_RULE);
    public static final /* enum */ NbQueryType TEXT_LIST = new NbQueryType(null, TextListTypeConvertor.INSTANCE, "text[]", LIST_RULE);
    public static final /* enum */ NbQueryType LONG = new NbQueryType(null, LongTypeConvertor.INSTANCE, "bigint", NUM_RULE);
    public static final /* enum */ NbQueryType LONG_LIST = new NbQueryType(null, LongListTypeConvertor.INSTANCE, "bigint[]", LIST_RULE);
    public static final /* enum */ NbQueryType INT = new NbQueryType(null, IntTypeConvertor.INSTANCE, "integer", NUM_RULE);
    public static final /* enum */ NbQueryType INT_LIST = new NbQueryType(null, IntListTypeConvertor.INSTANCE, "integer[]", LIST_RULE);
    public static final /* enum */ NbQueryType DATE = new NbQueryType("\u65e5\u671f", DateTypeConvertor.INSTANCE, "timestamp", NUM_RULE);
    public static final /* enum */ NbQueryType DOUBLE = new NbQueryType(null, DoubleTypeConvertor.INSTANCE, "double precision", NUM_RULE);
    public static final /* enum */ NbQueryType BOOL = new NbQueryType(null, BoolTypeConvertor.INSTANCE, "bool", BOOL_RULE);
    public static final /* enum */ NbQueryType ENUM = new NbQueryType(null, EnumTypeConvertor.INSTANCE, "text", STRING_RULE);
    public static final /* enum */ NbQueryType ENUM_LIST = new NbQueryType(null, TextListTypeConvertor.INSTANCE, "text[]", LIST_RULE);
    public static final /* enum */ NbQueryType MAP_ENUM = new NbQueryType(null, MapEnumConvertor.INSTANCE, "text", STRING_RULE);
    public static final /* enum */ NbQueryType MAP_ENUM_LIST = new NbQueryType(null, NoTypeConvertor.INSTANCE, "text[]", LIST_RULE);
    public static final /* enum */ NbQueryType AUTO_INCR_DOUBLE = new NbQueryType(null, DoubleTypeConvertor.INSTANCE, null, NUM_RULE);
    public static final /* enum */ NbQueryType DECIMAL = new NbQueryType("\u6570\u5b57", DecimalConvertor.INSTANCE, "decimal(10,5)", NUM_RULE);
    public static final /* enum */ NbQueryType FLOAT = new NbQueryType(null, FloatTypeConvertor.INSTANCE, null, NUM_RULE);
    public static final /* enum */ NbQueryType UNKNOWN = new NbQueryType(null, FloatTypeConvertor.INSTANCE, null, null);
    public static final /* enum */ NbQueryType FUNC = new NbQueryType(null, FloatTypeConvertor.INSTANCE, null, null);
    private static final Logger log;
    private final ITypeConvertor convert;
    private final String dbTypeSql;
    private final List<QueryRuleEnum> queryRules;
    private final String title;
    private static final /* synthetic */ NbQueryType[] $VALUES;

    public static NbQueryType[] values() {
        return (NbQueryType[])$VALUES.clone();
    }

    public static NbQueryType valueOf(String name) {
        return Enum.valueOf(NbQueryType.class, name);
    }

    private NbQueryType(String title, ITypeConvertor convert, String createSql, List<QueryRuleEnum> queryRules) {
        this.convert = convert;
        this.dbTypeSql = createSql;
        this.queryRules = queryRules;
        this.title = title;
    }

    public static INbQueryType convertFromClass(Class<?> fieldClazz, Type fieldType) {
        if (String.class.equals(fieldClazz)) {
            return TEXT;
        }
        if (Long.class.equals(fieldClazz)) {
            return LONG;
        }
        if (Integer.class.equals(fieldClazz)) {
            return INT;
        }
        if (Double.class.equals(fieldClazz)) {
            return DOUBLE;
        }
        if (Boolean.class.equals(fieldClazz)) {
            return BOOL;
        }
        if (LocalDateTime.class.equals(fieldClazz)) {
            return DATE;
        }
        if (Collection.class.isAssignableFrom(fieldClazz)) {
            if (fieldType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)fieldType;
                Type[] types = pt.getActualTypeArguments();
                if (types == null) {
                    return new JsonNbType();
                }
                Assert.isTrue((types.length == 1 ? 1 : 0) != 0, () -> new NbSQLMessageException("list\u7c7b\u578b\u5b57\u6bb5\u6cdb\u578b\u53ea\u652f\u6301\u4e00\u4e2a", new Object[0]));
                Class clazz = (Class)types[0];
                if (String.class.isAssignableFrom(clazz)) {
                    return TEXT_LIST;
                }
                if (Long.class.equals((Object)clazz)) {
                    return LONG_LIST;
                }
                if (clazz.isEnum()) {
                    return TEXT_LIST;
                }
                if (BeanUtil.isBean((Class)clazz)) {
                    return new JsonNbType(true);
                }
                throw new NbSQLMessageException("list\u4e0d\u652f\u6301\u7c7b\u578b:{}", clazz.getSimpleName());
            }
            if (JSONArray.class.isAssignableFrom(fieldClazz)) {
                return new JsonNbType(true);
            }
            throw new NbSQLException("\u96c6\u5408\u7c7b\u578b\u89e3\u6790\u5931\u8d25", new Object[0]);
        }
        if (Map.class.isAssignableFrom(fieldClazz)) {
            return new JsonNbType(false);
        }
        if (BeanUtil.isBean(fieldClazz)) {
            return new JsonNbType(false);
        }
        if (INbEnum.class.isAssignableFrom(fieldClazz)) {
            return MAP_ENUM;
        }
        if (fieldClazz.isEnum()) {
            return TEXT;
        }
        if (JSON.class.isAssignableFrom(fieldClazz)) {
            return new JsonNbType(null);
        }
        throw new NbSQLException("class\u7c7b\u578b:{},\u6682\u4e0d\u652f\u6301", fieldClazz.getName());
    }

    @Override
    public NbQueryType getArrayType() {
        switch (this) {
            case ENUM: 
            case TEXT: {
                return TEXT_LIST;
            }
            case LONG: {
                return LONG_LIST;
            }
            case INT: {
                return INT_LIST;
            }
            case MAP_ENUM: {
                return MAP_ENUM_LIST;
            }
        }
        throw new NbSQLMessageException("\u7c7b\u578b:{},\u6682\u4e0d\u652f\u6301\u6570\u7ec4\u67e5\u8be2", this.name());
    }

    @Override
    public NbQueryType getArraySubType() {
        switch (this) {
            case TEXT_LIST: {
                return TEXT;
            }
            case LONG_LIST: {
                return LONG;
            }
            case INT_LIST: {
                return INT;
            }
            case MAP_ENUM_LIST: {
                return MAP_ENUM;
            }
            case ENUM_LIST: {
                return ENUM;
            }
        }
        throw new NbSQLException("\u7c7b\u578b:{},\u6682\u4e0d\u652f\u6301\u83b7\u53d6\u6570\u7ec4\u5b50\u7c7b\u578b", this);
    }

    @Override
    public DbDataType getDbDataType() {
        switch (this) {
            case TEXT_LIST: 
            case LONG_LIST: 
            case INT_LIST: 
            case MAP_ENUM_LIST: 
            case ENUM_LIST: {
                return DbDataType.ARRAY;
            }
        }
        return DbDataType.GENERAL;
    }

    @Override
    @Deprecated
    public Object convert(Object value) throws TypeConvertException {
        return this.convert.convert(value);
    }

    @Override
    public void whereIn(NbQuerier<?> querier, MergeSegments expression, QueryRuleEnum ruleEnum, String name, Object value) {
        if (!this.isArray()) {
            this.defaultWhereIn(querier, expression, ruleEnum, name, value);
            return;
        }
        INbQueryType.super.whereIn(querier, expression, ruleEnum, name, value);
    }

    @Override
    public boolean orderAble() {
        return !this.isArray();
    }

    public void defaultWhereIn(NbQuerier<?> querier, MergeSegments expression, QueryRuleEnum ruleEnum, String name, Object value) {
        if (value instanceof ISqlSegment) {
            expression.add(() -> name, ruleEnum, (ISqlSegment)value);
        } else {
            Assert.isTrue((boolean)(value instanceof Collection), () -> new NbSQLMessageException("$in\u67e5\u8be2\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u7ec4", new Object[0]));
            List listValue = Convert.toList((Object)value);
            Assert.notEmpty((Iterable)listValue, () -> new NbSQLMessageException("\u67e5\u8be2\u6761\u4ef6\u6570\u7ec4\u503c\u4e0d\u80fd\u4e3a\u7a7a,\u5b57\u6bb5:{}", name));
            String paramKey = querier.formatVariable(this.getArrayType(), value, false);
            expression.add(() -> name, ruleEnum, () -> paramKey);
        }
    }

    @Override
    public void whereLike(NbQuerier<?> querier, MergeSegments expression, String name, Object value) {
        Assert.isTrue((this == TEXT ? 1 : 0) != 0, (String)"\u7c7b\u578b:{},\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2", (Object[])new Object[]{this});
        assert (value instanceof String) : "\u6a21\u7cca\u67e5\u8be2\u5fc5\u987b\u4f20\u5165\u5b57\u7b26\u4e32";
        String valueStr = (String)value;
        valueStr = StrUtil.removePrefix((CharSequence)valueStr, (CharSequence)"%");
        valueStr = StrUtil.removeSuffix((CharSequence)valueStr, (CharSequence)"%");
        value = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{"%", valueStr, "%"});
        String paramKey = querier.formatVariable(this, value, false);
        expression.add(() -> name, QueryRuleEnum.LIKE, () -> paramKey);
    }

    public ITypeConvertor getConvert() {
        return this.convert;
    }

    @Override
    public String getDbTypeSql() {
        return this.dbTypeSql;
    }

    @Override
    public List<QueryRuleEnum> getQueryRules() {
        return this.queryRules;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    static {
        $VALUES = new NbQueryType[]{TEXT, TEXT_LIST, LONG, LONG_LIST, INT, INT_LIST, DATE, DOUBLE, BOOL, ENUM, ENUM_LIST, MAP_ENUM, MAP_ENUM_LIST, AUTO_INCR_DOUBLE, DECIMAL, FLOAT, UNKNOWN, FUNC};
        log = LoggerFactory.getLogger(NbQueryType.class);
    }
}

