/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.type;

import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import cn.hperfect.nbquerier.enums.DbDataType;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.enums.SqlKeyword;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface INbQueryType
extends Serializable {
    public static final List<QueryRuleEnum> LIST_RULE = ListUtil.toList((Object[])new QueryRuleEnum[]{QueryRuleEnum.NOT_NULL, QueryRuleEnum.NOT_EMPTY, QueryRuleEnum.EMPTY, QueryRuleEnum.INTERS, QueryRuleEnum.NULL, QueryRuleEnum.IN, QueryRuleEnum.NOT_IN, QueryRuleEnum.ANY, QueryRuleEnum.NOT_ANY});
    public static final List<QueryRuleEnum> NUM_RULE = ListUtil.toList((Object[])new QueryRuleEnum[]{QueryRuleEnum.NOT_NULL, QueryRuleEnum.NULL, QueryRuleEnum.EQ, QueryRuleEnum.NE, QueryRuleEnum.BETWEEN, QueryRuleEnum.GT, QueryRuleEnum.GE, QueryRuleEnum.LE, QueryRuleEnum.LT, QueryRuleEnum.IN, QueryRuleEnum.NOT_IN});
    public static final List<QueryRuleEnum> BOOL_RULE = ListUtil.toList((Object[])new QueryRuleEnum[]{QueryRuleEnum.NOT_NULL, QueryRuleEnum.NULL, QueryRuleEnum.EQ, QueryRuleEnum.NE});
    public static final List<QueryRuleEnum> STRING_RULE = ListUtil.toList((Object[])new QueryRuleEnum[]{QueryRuleEnum.NOT_NULL, QueryRuleEnum.NULL, QueryRuleEnum.EQ, QueryRuleEnum.NE, QueryRuleEnum.LIKE, QueryRuleEnum.IN, QueryRuleEnum.NOT_IN, QueryRuleEnum.NOT_BLANK, QueryRuleEnum.BLANK, QueryRuleEnum.EMPTY, QueryRuleEnum.NOT_EMPTY});

    default public NbQueryType getArrayType() {
        throw new NbSQLException("\u7c7b\u578b:{},\u6682\u4e0d\u652f\u6301\u6570\u7ec4\u67e5\u8be2", this);
    }

    default public NbQueryType getArraySubType() {
        throw new NbSQLException("\u7c7b\u578b:{},\u6682\u4e0d\u652f\u6301\u83b7\u53d6\u6570\u7ec4\u5b50\u7c7b\u578b", this);
    }

    public DbDataType getDbDataType();

    default public boolean isArray() {
        return this.getDbDataType() == DbDataType.ARRAY;
    }

    default public boolean isJson() {
        return this.getDbDataType() == DbDataType.JSON;
    }

    public Object convert(Object var1) throws TypeConvertException;

    public String getDbTypeSql();

    public String getTitle();

    public void whereLike(NbQuerier<?> var1, MergeSegments var2, String var3, Object var4);

    default public void whereIn(NbQuerier<?> querier, MergeSegments expression, QueryRuleEnum ruleEnum, String name, Object value) {
        throw new NbSQLMessageException("\u7c7b\u578b:{},\u4e0d\u652f\u6301in\u67e5\u8be2", this.getTitle());
    }

    public List<QueryRuleEnum> getQueryRules();

    default public void setWhereCondition(NbQuerier<?> querier, MergeSegments expression, QueryRuleEnum ruleEnum, String name, Object value) {
        List<QueryRuleEnum> queryRules = this.getQueryRules();
        Assert.isTrue((queryRules == null || CollUtil.contains(queryRules, (Object)ruleEnum) ? 1 : 0) != 0, (String)"\u7c7b\u578b:{}\u6682\u65f6\u4e0d\u652f\u6301:{}\u64cd\u4f5c,\u53ea\u652f\u6301:{}", (Object[])new Object[]{this.getTitle(), ruleEnum, queryRules});
        switch (ruleEnum) {
            case IN: 
            case NOT_IN: {
                this.whereIn(querier, expression, ruleEnum, name, value);
                break;
            }
            case LIKE: {
                if (StrUtil.isBlankIfStr((Object)value)) break;
                this.whereLike(querier, expression, name, value);
                break;
            }
            case NOT_EMPTY: 
            case EMPTY: {
                if (this.isJson()) {
                    JsonNbType jsonNbType = (JsonNbType)this;
                    if (jsonNbType.isJsonArray()) {
                        String key = StrUtil.format((CharSequence)"coalesce(jsonb_array_length({}),0)", (Object[])new Object[]{name});
                        QueryRuleEnum rule = ruleEnum == QueryRuleEnum.EMPTY ? QueryRuleEnum.EQ : QueryRuleEnum.GT;
                        String paramKey = querier.formatVariable(NbQueryType.INT, 0, false);
                        expression.add(() -> key, rule, () -> paramKey);
                        break;
                    }
                    throw new NbSQLMessageException("\u6682\u65f6\u672a\u5b9e\u73b0json\u7c7b\u578b\u7a7a\u67e5\u8be2", new Object[0]);
                }
                if (this.isArray()) {
                    String key = StrUtil.format((CharSequence)"coalesce(array_length({}, 1),0)", (Object[])new Object[]{name});
                    QueryRuleEnum rule = ruleEnum == QueryRuleEnum.EMPTY ? QueryRuleEnum.EQ : QueryRuleEnum.GT;
                    String paramKey = querier.formatVariable(NbQueryType.INT, 0, false);
                    expression.add(() -> key, rule, () -> paramKey);
                    break;
                }
                if (this.equals(NbQueryType.TEXT)) {
                    QueryRuleEnum rule = ruleEnum == QueryRuleEnum.EMPTY ? QueryRuleEnum.BLANK : QueryRuleEnum.NOT_BLANK;
                    this.setWhereCondition(querier, expression, rule, name, value);
                    break;
                }
                throw new NbSQLMessageException("\u8be5\u7c7b\u578b\u4e0d\u652f\u6301 EMPTY \u64cd\u4f5c", new Object[0]);
            }
            case BETWEEN: {
                List list = Convert.toList((Object)value);
                if (CollUtil.isEmpty((Collection)list)) break;
                Assert.isTrue((list.size() > 1 ? 1 : 0) != 0, (String)"$bt\u53d6\u4e2d\u95f4\u5fc5\u987b\u8981\u6709\u4e24\u4e2a\u503c", (Object[])new Object[0]);
                Object[] objects = list.toArray();
                expression.add(() -> name, ruleEnum, () -> querier.formatVariable(this, objects[0], false), SqlKeyword.AND, () -> querier.formatVariable(this, objects[1], false));
                break;
            }
            case NULL: 
            case NOT_NULL: {
                expression.add(() -> name, ruleEnum);
                break;
            }
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LT: 
            case LE: {
                if (StrUtil.isBlankIfStr((Object)value)) break;
                this.whereOperation(querier, expression, ruleEnum, name, value);
                break;
            }
            case NOT_BLANK: 
            case BLANK: {
                String key = StrUtil.format((CharSequence)"trim(coalesce({}, ''))", (Object[])new Object[]{name});
                QueryRuleEnum rule = ruleEnum == QueryRuleEnum.BLANK ? QueryRuleEnum.EQ : QueryRuleEnum.NE;
                this.whereOperation(querier, expression, rule, key, "");
                break;
            }
            case INTERS: {
                String paramKey = querier.formatVariable(this, value, true);
                expression.add(() -> name, ruleEnum, () -> paramKey);
                break;
            }
            case ANY: 
            case NOT_ANY: {
                DbType dbType = querier.getDbType();
                Assert.isTrue((dbType == DbType.POSTGRE_SQL || dbType == DbType.PG_NG ? 1 : 0) != 0, (String)"\u53ea\u6709POSTGRESQL\u652f\u6301ANY\u64cd\u4f5c", (Object[])new Object[0]);
                if (ruleEnum == QueryRuleEnum.NOT_ANY) {
                    expression.add(SqlKeyword.NOT);
                }
                if (value instanceof Collection) {
                    String paramKey = querier.formatVariable(this, value, false, false);
                    expression.add(() -> name, SqlKeyword.ARRAY_OVERLAP, () -> paramKey);
                    break;
                }
                String paramKey = querier.formatVariable(this.getArraySubType(), value, false, false);
                expression.add(() -> paramKey, ruleEnum == QueryRuleEnum.ANY ? SqlKeyword.EQ : SqlKeyword.NE, SqlKeyword.ANY, () -> StrUtil.format((CharSequence)"({})", (Object[])new Object[]{name}));
                break;
            }
            default: {
                throw new NbSQLException("\u6682\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", new Object[0]);
            }
        }
    }

    default public void whereOperation(NbQuerier<?> querier, MergeSegments expression, QueryRuleEnum ruleEnum, String name, Object value) {
        String paramKey = querier.formatVariable(this, value, false);
        expression.add(() -> name, ruleEnum, () -> paramKey);
    }

    public boolean orderAble();

    default public Object formatImportValue(String val) {
        return null;
    }
}

