/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.result;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.result.IResultSetHandler;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSONUtil;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.postgresql.util.PGobject;

public class DefaultResultSetHandler
implements IResultSetHandler {
    private final NbQuerierProperties config;

    public DefaultResultSetHandler(NbQuerierProperties config) {
        this.config = config;
    }

    @Override
    public List<LinkedHashMap<String, Object>> toMap(ResultSet rs) throws SQLException {
        ArrayList<LinkedHashMap<String, Object>> maps = new ArrayList<LinkedHashMap<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            int columnCount = md.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                Object object = rs.getObject(i);
                String typeName = md.getColumnTypeName(i);
                Object value = null;
                if (object != null) {
                    if (object instanceof Array) {
                        value = ((Array)object).getArray();
                    } else if (object instanceof Timestamp) {
                        value = Convert.toLocalDateTime((Object)object);
                    } else if ("json".equals(typeName) || "jsonb".equals(typeName)) {
                        if (this.config.getDbType() == DbType.PG_NG) {
                            value = JSONUtil.isJsonArray((String)object.toString()) ? JSONUtil.parseArray((Object)object) : JSONUtil.parseObj((Object)object);
                        } else if (object instanceof PGobject) {
                            PGobject pGobject = (PGobject)object;
                            if (JSONUtil.isJsonArray((String)pGobject.getValue())) {
                                value = JSONUtil.parseArray((String)pGobject.getValue());
                            } else if (JSONUtil.isJson((String)pGobject.getValue())) {
                                value = JSONUtil.parseObj((String)pGobject.getValue());
                            }
                        }
                    } else {
                        value = object;
                    }
                }
                rowData.put(md.getColumnLabel(i), value);
            }
            maps.add(rowData);
        }
        return maps;
    }

    Object handlerPGobject(Object value) {
        if (value == null) {
            return null;
        }
        if (this.config.getDbType() == DbType.POSTGRE_SQL) {
            // empty if block
        }
        return value;
    }
}

