/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl;

import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.ConstraintException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;

public enum UniqueValidator implements IValidator
{
    INSTANCE;


    @Override
    public void doUpdateValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        this.doValidate(tableInfo, nbField, dataList, true);
    }

    @Override
    public void doSaveValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        this.doValidate(tableInfo, nbField, dataList, false);
    }

    private void doValidate(NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList, boolean isUpdate) {
        String name = nbField.getName();
        String pkName = tableInfo.getPkName();
        for (Map<String, Object> map : dataList) {
            Object value = map.get(name);
            Assert.isFalse((!isUpdate && StrUtil.isBlankIfStr((Object)value) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6,\u67e5\u91cd\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Object pkValue = map.get(pkName);
            if (pkValue == null || value == null) {
                return;
            }
            boolean exist = NbQuerier.table(tableInfo).where(name, value, true).with(isUpdate, i -> i.where(pkName, QueryRuleEnum.NE, pkValue, true)).exist();
            if (!exist) continue;
            throw new ConstraintException(nbField, "\u5b58\u5728\u503c:" + value, tableInfo.getTableName());
        }
    }

    @Override
    public String getName() {
        return "UNIQUE";
    }
}

