/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.dialect;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.dialect.IDialectWare;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import java.util.List;

public class DefaultDialectWare
implements IDialectWare {
    private final NbQuerierProperties config;
    private static final List<String> MYSQL_KEYS = ListUtil.toList((Object[])new String[]{"show"});
    private static final List<String> PG_KEYS = ListUtil.toList((Object[])new String[]{"order"});

    public DefaultDialectWare(NbQuerierProperties config) {
        this.config = config;
    }

    @Override
    public <T> void limit(NbQuerier<T> querier, int offset, int length) {
        DbType dbType = this.config.getDbType();
        switch (dbType) {
            case PG_NG: 
            case POSTGRE_SQL: {
                querier.last(StrUtil.format((CharSequence)"LIMIT {} offset {}", (Object[])new Object[]{length, offset}));
                break;
            }
            case MYSQL: {
                querier.last(StrUtil.format((CharSequence)"LIMIT {},{}", (Object[])new Object[]{offset, length}));
                break;
            }
            default: {
                throw new NbSQLMessageException("\u672a\u5b9e\u73b0\u6570\u636e\u5e93\u7c7b\u578b\u4e3a:{}\u7684limit(int,int)\u65b9\u6cd5", dbType.getDb());
            }
        }
    }

    @Override
    public String quotSqlKey(String key) {
        DbType dbType = this.config.getDbType();
        switch (dbType) {
            case MYSQL: {
                if (!MYSQL_KEYS.contains(key)) break;
                return StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{key});
            }
            case POSTGRE_SQL: {
                if (!PG_KEYS.contains(key)) break;
                return StrUtil.format((CharSequence)"'{}'", (Object[])new Object[]{key});
            }
        }
        return key;
    }
}

