/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.core.components.builder.impl.AliasBuilder;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Table;

public class TableBuilder {
    Map<String, Table> tableMap = new HashMap<String, Table>();
    private final AliasBuilder aliasBuilder;

    public TableBuilder() {
        this.aliasBuilder = new AliasBuilder();
    }

    public TableBuilder(AliasBuilder aliasBuilder) {
        this.aliasBuilder = aliasBuilder;
    }

    public Table putTable(String schema, String tableId, String alias) {
        String key = SqlUtils.withAlias(schema, tableId);
        if (this.tableMap.containsKey(key)) {
            return this.tableMap.get(key);
        }
        Table table = new Table(schema, tableId);
        table.setAlias(new Alias(alias, false));
        this.tableMap.put(key, table);
        return table;
    }

    public Table putTable(String schema, String tableId) {
        return this.putTable(schema, tableId, this.aliasBuilder.putTable(tableId));
    }

    public Table putTable(Table table) {
        return this.putTable(table.getSchemaName(), table.getName());
    }

    public Table putTable(INbTable nbTable) {
        return this.putTable(nbTable.getSchema(), nbTable.getTableName());
    }
}

