/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.core.components.builder.impl;

import cn.hperfect.nbquerier.annotation.IgnoreSoftDelete;
import cn.hperfect.nbquerier.annotation.NbConstraint;
import cn.hperfect.nbquerier.annotation.NbField;
import cn.hperfect.nbquerier.annotation.NbOrderField;
import cn.hperfect.nbquerier.annotation.NbTable;
import cn.hperfect.nbquerier.annotation.NbTableOrder;
import cn.hperfect.nbquerier.annotation.NbTableOrders;
import cn.hperfect.nbquerier.annotation.NbView;
import cn.hperfect.nbquerier.annotation.TableFk;
import cn.hperfect.nbquerier.annotation.TableId;
import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.config.properties.FillStrategyProperties;
import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.components.builder.INbQueryBuilder;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FieldFillStrategyRegistry;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.IFieldApplier;
import cn.hperfect.nbquerier.core.components.route.ISchemaRoute;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.OrderInfo;
import cn.hperfect.nbquerier.core.metedata.ParseContext;
import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.core.metedata.UnknownClass;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.metedata.table.ClassNbTable;
import cn.hperfect.nbquerier.core.metedata.table.ThisTable;
import cn.hperfect.nbquerier.core.querier.DefaultNbQuerier;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.IdType;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNbQueryBuilder
implements INbQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultNbQueryBuilder.class);
    private final NbQuerierProperties config;
    private final NbQuerierConfiguration configuration;
    private final FieldFillStrategyRegistry strategyRegistry;
    private static final Cache<Class<?>, ClassNbTable> TABLE_INFOS = CacheUtil.newLFUCache((int)100);

    public DefaultNbQueryBuilder(NbQuerierConfiguration configuration) {
        this.config = configuration.getConfig();
        this.configuration = configuration;
        this.strategyRegistry = configuration.getFieldFillStrategyRegistry();
    }

    private ISchemaRoute getSchemaRoute() {
        return this.configuration.getSchemaRoute();
    }

    @Override
    public <T> NbQuerier<T> build(Class<T> clazz, String alias) {
        DefaultNbQuerier<T> querier = this.newNbQuerier();
        NbQueryInfo nbQueryInfo = this.buildQueryInfo(clazz, alias);
        querier.setQueryInfo(nbQueryInfo);
        querier.setResultClass((Class)clazz);
        return querier;
    }

    @Override
    public <T> NbQuerier<T> build(NbQuerier<?> outer, Class<T> clazz) {
        DefaultNbQuerier<T> querier = this.newNbQuerier();
        NbQueryInfo nbQueryInfo = this.buildQueryInfo(clazz, null);
        querier.setQueryInfo(nbQueryInfo);
        querier.setResultClass((Class)clazz);
        return querier;
    }

    @Override
    public <T> NbQuerier<T> build(INbTable nbTable, Class<T> clazz, String alias) {
        NbQueryInfo queryInfo = this.buildQueryInfo(nbTable, alias);
        return this.build(queryInfo, clazz);
    }

    public <T> NbQuerier<T> build(NbQueryInfo queryInfo, Class<T> clazz) {
        DefaultNbQuerier<T> querier = this.newNbQuerier();
        querier.setQueryInfo(queryInfo);
        querier.setResultClass((Class)clazz);
        return querier;
    }

    @Override
    public <T> NbQuerier<T> build(NbQueryInfo queryInfo) {
        DefaultNbQuerier<T> querier = this.newNbQuerier();
        querier.setQueryInfo(queryInfo);
        return querier;
    }

    @Override
    public <T> DefaultNbQuerier<T> newNbQuerier() {
        return new DefaultNbQuerier(this.configuration);
    }

    @Override
    public NbQueryInfo buildQueryInfo(INbTable nbTable, String alias) {
        Assert.notNull((Object)nbTable, (String)"table\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (ThisTable.ME.equals(nbTable)) {
            NbQueryInfo queryInfo = new NbQueryInfo();
            queryInfo.setTable(nbTable);
            return queryInfo;
        }
        NbQueryInfo queryInfo = new NbQueryInfo();
        String tableName = nbTable.getTableName();
        Assert.notBlank((CharSequence)tableName, (String)"\u67e5\u8be2\u4fe1\u606f\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        queryInfo.setTable(nbTable);
        queryInfo.setAlias(alias);
        queryInfo.setDs(nbTable.getDs());
        if (StrUtil.isBlank((CharSequence)nbTable.getSchema())) {
            ISchemaRoute schemaRoute = this.getSchemaRoute();
            if (schemaRoute != null) {
                queryInfo.setSchema(schemaRoute.determineSchema(nbTable.getTableName()));
            }
        } else {
            queryInfo.setSchema(nbTable.getSchema());
        }
        return queryInfo;
    }

    @Override
    public NbQueryInfo buildQueryInfo(NbQuerier<?> querier, String alias) {
        NbQueryInfo queryInfo = new NbQueryInfo();
        queryInfo.setAlias(alias);
        return queryInfo;
    }

    @Override
    public NbQueryInfo buildQueryInfo(Class<?> tableClazz, String alias) {
        Assert.notNull(tableClazz, (String)"table\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ClassNbTable tableInfo = this.parseTableInfo(tableClazz);
        NbQueryInfo queryInfo = this.buildQueryInfo(tableInfo, alias);
        queryInfo.setClass(true);
        return queryInfo;
    }

    @Override
    public ClassNbTable parseTableInfo(Class<?> tableClazz) {
        return this.parseTableInfo(new ParseContext(), tableClazz);
    }

    public ClassNbTable parseTableInfo(ParseContext context, Class<?> tableClazz) {
        ClassNbTable tableInfo = (ClassNbTable)TABLE_INFOS.get(tableClazz);
        if (tableInfo == null || !this.config.isClassCache()) {
            tableInfo = context.getTableInfo(tableClazz);
            if (tableInfo != null) {
                return tableInfo;
            }
            tableInfo = context.createClassNbTable(tableClazz);
            NbTable nbTable = tableClazz.getAnnotation(NbTable.class);
            if (nbTable != null) {
                if (StrUtil.isNotBlank((CharSequence)nbTable.value())) {
                    tableInfo.setTableName(nbTable.value());
                }
                tableInfo.setSchema(nbTable.schema());
                tableInfo.setDs(nbTable.ds());
                tableInfo.setPermType(nbTable.perm());
            }
            if (StrUtil.isBlank((CharSequence)tableInfo.getTableName())) {
                tableInfo.setTableName(tableClazz.getSimpleName());
                if (this.config.isTableNameToUnderlineCase()) {
                    tableInfo.setTableName(StrUtil.toUnderlineCase((CharSequence)tableInfo.getTableName()));
                }
            }
            BeanDesc beanDesc = BeanUtil.getBeanDesc(tableClazz);
            tableInfo.setFields(this.parseFields(context, tableInfo, beanDesc));
            this.setOrderInfo(tableInfo, tableClazz);
            if (this.config.isClassCache()) {
                TABLE_INFOS.put(tableClazz, (Object)tableInfo);
            }
            this.checkSoftDelete(tableInfo, tableClazz);
        }
        return tableInfo;
    }

    private void setOrderInfo(ClassNbTable tableInfo, Class<?> tableClazz) {
        NbTableOrders orders = tableClazz.getAnnotation(NbTableOrders.class);
        if (orders != null) {
            NbTableOrder[] value;
            ArrayList<OrderInfo> orderInfos = new ArrayList<OrderInfo>();
            for (NbTableOrder nbTableOrder : value = orders.value()) {
                OrderInfo orderInfo = new OrderInfo();
                orderInfo.setOrderType(nbTableOrder.type());
                String orderName = StrUtil.toUnderlineCase((CharSequence)nbTableOrder.fieldName());
                ClassNbField field = (ClassNbField)CollUtil.findOne(tableInfo.getFields(), i -> i.getName().equals(orderName));
                Assert.notNull((Object)field, (String)"\u8868\u5355{}\u6392\u5e8f\u6ce8\u89e3\u4e2d,\u6392\u5e8f\u5b57\u6bb5:{}\u4e0d\u5b58\u5728", (Object[])new Object[]{tableInfo.getTableName(), orderName});
                orderInfo.setNbField(field);
                orderInfos.add(orderInfo);
            }
            tableInfo.setOrderInfos(orderInfos);
        }
    }

    private void checkSoftDelete(ClassNbTable tableInfo, Class<?> tableClazz) {
        IgnoreSoftDelete ignoreSoftDelete;
        if (tableInfo.getDeleteField() == null && this.config.isSoftDeleteNotice() && (ignoreSoftDelete = tableClazz.getAnnotation(IgnoreSoftDelete.class)) == null && tableClazz.getAnnotation(NbView.class) == null) {
            log.error("\u8868\u5355:{}\u6ca1\u6709\u8f6f\u5220\u9664\u5b57\u6bb5,\u5982\u679c\u4e0d\u9700\u8981\u8f6f\u5220\u9664\u8bf7\u4f7f\u7528@IgnoreSoftDelete \u6ce8\u89e3", (Object)tableInfo.getTableName());
        }
    }

    public List<ClassNbField> parseFields(ParseContext context, ClassNbTable tableInfo, BeanDesc beanDesc) {
        ArrayList<ClassNbField> nbTableFields = new ArrayList<ClassNbField>();
        String softDeleteField = this.config.getSoftDeleteField();
        for (PropDesc prop : beanDesc.getProps()) {
            NbField nbField;
            Class<Dict> declaringClass = prop.getField().getDeclaringClass();
            boolean isFromDict = declaringClass.isAssignableFrom(Dict.class);
            if (isFromDict) continue;
            Field field = prop.getField();
            ClassNbField classNbField = new ClassNbField();
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || (nbField = field.getAnnotation(NbField.class)) != null && this.parseNbField(context, field, classNbField, nbField)) continue;
            if (StrUtil.isBlank((CharSequence)classNbField.getName())) {
                String fieldName = field.getName();
                if (this.config.isFieldNameToUnderlineCase()) {
                    classNbField.setName(StrUtil.toUnderlineCase((CharSequence)fieldName));
                } else {
                    classNbField.setName(fieldName);
                }
            }
            classNbField.setFieldType(NbFieldType.NORMAL);
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId != null) {
                this.parseTableId(tableInfo, classNbField, tableId);
            }
            classNbField.setPropName(field.getName());
            if (nbField != null && nbField.type() != NbQueryType.UNKNOWN) {
                classNbField.setQueryType(nbField.type());
            } else {
                Type genericType = field.getGenericType();
                try {
                    INbQueryType nbQueryType = NbQueryType.convertFromClass(field.getType(), genericType);
                    classNbField.setQueryType(nbQueryType);
                    if (nbQueryType == NbQueryType.MAP_ENUM) {
                        Class<?> type = field.getType();
                        ?[] enumConstants = type.getEnumConstants();
                        Method getNameMethod = type.getMethod("name", new Class[0]);
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (Object enumConstant : enumConstants) {
                            String name = (String)getNameMethod.invoke(enumConstant, new Object[0]);
                            map.put(name, enumConstant);
                        }
                        classNbField.setEnumMap(map);
                    }
                }
                catch (Exception throwable) {
                    throw new NbSQLException("table:{},\u5b57\u6bb5\u7c7b\u578b:{},\u7c7b\u578b\u89e3\u6790\u5931\u8d25:{}", tableInfo.getTableName(), field.getName(), throwable);
                }
            }
            if (StrUtil.isNotBlank((CharSequence)softDeleteField) && softDeleteField.equals(classNbField.getName())) {
                classNbField.setFieldType(NbFieldType.DELETE);
                tableInfo.setDeleteField(classNbField);
            }
            this.setFk(context, field, classNbField);
            this.setOrderField(field, classNbField);
            this.setConstraint(field, classNbField);
            this.setFillStrategy(classNbField);
            nbTableFields.add(classNbField);
        }
        return nbTableFields;
    }

    private void setOrderField(Field field, ClassNbField classNbField) {
        NbOrderField annotation = field.getAnnotation(NbOrderField.class);
        if (annotation != null) {
            classNbField.setFieldType(NbFieldType.ORDER);
        }
    }

    private void setConstraint(Field field, ClassNbField classNbField) {
        NbConstraint annotation = field.getAnnotation(NbConstraint.class);
        classNbField.setNotNull(false);
        if (annotation != null) {
            ValidateRule validateRule;
            ArrayList<ValidateRule> validateRules = new ArrayList<ValidateRule>();
            classNbField.setNotNull(annotation.notNull());
            if (annotation.notNull()) {
                validateRule = new ValidateRule("NOT_NULL");
                validateRule.setMsg(annotation.isNullMessage());
                validateRules.add(validateRule);
            }
            if (annotation.unique()) {
                validateRule = new ValidateRule("UNIQUE");
                validateRule.setMsg(annotation.notUniqueMessage());
                validateRules.add(validateRule);
            }
            classNbField.setValidateRules(validateRules);
        }
    }

    private boolean parseNbField(ParseContext context, Field field, ClassNbField classNbField, NbField nbField) {
        classNbField.setInsertDefault(nbField.insertDefault());
        classNbField.setDescription(nbField.description());
        String fieldAlias = nbField.alias();
        if (StrUtil.isBlank((CharSequence)fieldAlias) && nbField.type() == NbQueryType.FUNC) {
            fieldAlias = field.getName();
        }
        if (StrUtil.isNotBlank((CharSequence)fieldAlias)) {
            classNbField.setAlias(StrUtil.toUnderlineCase((CharSequence)fieldAlias));
        }
        if (!Objects.equals(nbField.table(), UnknownClass.class)) {
            classNbField.setTable(this.parseTableInfo(context, nbField.table()));
            Assert.isTrue((boolean)nbField.exist(), (String)"\u5b57\u6bb5:{}\u4e0d\u80fd\u88ab\u5ffd\u7565", (Object[])new Object[]{field.getName()});
        }
        if (!nbField.exist()) {
            return true;
        }
        if (StrUtil.isNotBlank((CharSequence)nbField.value())) {
            classNbField.setName(nbField.value());
        }
        return false;
    }

    private void parseTableId(ClassNbTable tableInfo, ClassNbField classNbField, TableId tableId) {
        IdType idType = tableId.type();
        if (StrUtil.isNotBlank((CharSequence)tableId.value())) {
            classNbField.setName(tableId.value());
        }
        if (idType == IdType.DEFAULT) {
            idType = this.config.getIdType();
        }
        PrimaryKey primaryKey = new PrimaryKey(classNbField.getName(), idType, tableId.queryType());
        tableInfo.setPk(primaryKey);
        classNbField.setFieldType(NbFieldType.PK);
        if (idType == IdType.ASSIGN_ID) {
            classNbField.setFillStrategy(this.strategyRegistry.getIdSnowflakeStrategy());
        } else if (idType == IdType.UUID) {
            throw new IllegalArgumentException("\u672a\u5b9e\u73b0uuid\u7b97\u6cd5\u751f\u6210");
        }
    }

    private void setFk(ParseContext context, Field field, ClassNbField classNbField) {
        TableFk tableFk = field.getAnnotation(TableFk.class);
        if (tableFk != null) {
            ClassNbTable classNbTable = this.parseTableInfo(context, tableFk.value());
            classNbField.setJoinTable(classNbTable);
            classNbField.setFieldType(NbFieldType.FK);
        }
    }

    private void setFillStrategy(ClassNbField classNbField) {
        if (CollUtil.isNotEmpty(this.config.getFillStrategies())) {
            for (FillStrategyProperties configStrategy : this.config.getFillStrategies()) {
                if (!classNbField.getName().equals(configStrategy.getFieldName())) continue;
                Assert.notEmpty((CharSequence)configStrategy.getApplier(), (String)"\u586b\u5145\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                IFieldApplier fieldApplier = this.strategyRegistry.getFieldApplier(configStrategy.getApplier());
                FillStrategy strategy = new FillStrategy(configStrategy.isSaveFill(), configStrategy.isUpdateFill(), configStrategy.getFillType(), fieldApplier);
                classNbField.setFillStrategy(strategy);
            }
        }
    }
}

