/*
 * Decompiled with CFR 0.152.
 */
package cn.hperfect.nbquerier.binding;

import cn.hperfect.nbquerier.annotation.sql.Delete;
import cn.hperfect.nbquerier.annotation.sql.Insert;
import cn.hperfect.nbquerier.annotation.sql.Select;
import cn.hperfect.nbquerier.annotation.sql.Update;
import cn.hperfect.nbquerier.binding.ArgVariable;
import cn.hperfect.nbquerier.binding.ParameterMappingTokenHandler;
import cn.hperfect.nbquerier.binding.ParameterReplaceTokenHandler;
import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.components.builder.impl.ParamBuilder;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.ResultType;
import cn.hperfect.nbquerier.enums.SqlCommandType;
import cn.hperfect.nbquerier.exceptions.NbSQLException;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hperfect.nbquerier.parsing.GenericTokenParser;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlMapperProxy<T>
implements InvocationHandler {
    private final List<Class<? extends Annotation>> sqlAnnotationTypes = ListUtil.toList((Object[])new Class[]{Select.class, Insert.class, Update.class, Delete.class});
    private final NbQuerierConfiguration configuration;

    public SqlMapperProxy(NbQuerierConfiguration configuration, Class<T> clazz) {
        this.configuration = configuration;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SqlCommandType sqlCommandType = this.getSqlCommandType(method);
        if (sqlCommandType == null) {
            throw new NbSQLException("\u65b9\u6cd5:{},\u65e0\u67e5\u8be2\u6ce8\u89e3sql", method.getName());
        }
        boolean isUpdate = sqlCommandType == SqlCommandType.UPDATE || sqlCommandType == SqlCommandType.INSERT;
        ParamBuilder paramBuilder = new ParamBuilder();
        String sql = this.getSqlStr(sqlCommandType, method);
        Map<String, ArgVariable> argVariableMap = this.getArgVariableMap(method, args);
        sql = new GenericTokenParser("#{", "}", new ParameterMappingTokenHandler(paramBuilder, isUpdate, argVariableMap)).parse(sql);
        sql = new GenericTokenParser("${", "}", new ParameterReplaceTokenHandler(argVariableMap)).parse(sql);
        if (isUpdate) {
            return this.getExecutor().doUpdate(null, sql, paramBuilder.getParams());
        }
        Class<?> returnClass = method.getReturnType();
        if (String.class.equals(returnClass)) {
            return this.getExecutor().doQuery(null, sql, paramBuilder.getParams(), ResultType.STRING);
        }
        if (Collection.class.isAssignableFrom(returnClass)) {
            Type beanClass = SqlMapperProxy.getBeanType(method);
            List maps = (List)this.getExecutor().doQuery(null, sql, paramBuilder.getParams(), ResultType.LIST);
            if (beanClass instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)beanClass).getRawType();
                if (Map.class.isAssignableFrom(rawType)) {
                    return maps;
                }
                throw new NbSQLMessageException("\u672a\u5904\u7406\u7ed3\u679c\u96c6\u8f6c\u6362\u7c7b\u578b:{}", rawType);
            }
            NbQuerier querier = NbQuerier.table((Class)beanClass);
            return maps.stream().map(querier::mapToBean).collect(Collectors.toList());
        }
        throw new NbSQLMessageException("\u6682\u672a\u5904\u7406\u8be5\u7c7b\u578b\u8fd4\u56de", new Object[0]);
    }

    public INbExecutor getExecutor() {
        return this.configuration.newNbExecutor();
    }

    private static Type getBeanType(Method method) {
        Type t = method.getGenericReturnType();
        ParameterizedType p = TypeUtil.toParameterizedType((Type)t);
        Assert.isTrue((p.getActualTypeArguments().length == 1 ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6cdb\u578blist\u8fd4\u56de", (Object[])new Object[0]);
        return p.getActualTypeArguments()[0];
    }

    private String getSqlStr(SqlCommandType sqlCommandType, Method method) {
        switch (sqlCommandType) {
            case SELECT: {
                return method.getAnnotation(Select.class).value();
            }
            case UPDATE: {
                return method.getAnnotation(Update.class).value();
            }
            case DELETE: {
                return method.getAnnotation(Delete.class).value();
            }
            case INSERT: {
                return method.getAnnotation(Insert.class).value();
            }
        }
        throw new NbSQLException("\u65e0\u6cd5\u89e3\u6790sql", new Object[0]);
    }

    private Map<String, ArgVariable> getArgVariableMap(Method method, Object[] args) {
        HashMap<String, ArgVariable> variableMap = new HashMap<String, ArgVariable>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Object value = args[i];
            variableMap.put(parameter.getName(), new ArgVariable(parameter, value));
        }
        return variableMap;
    }

    private SqlCommandType getSqlCommandType(Method method) {
        Class<Annotation> type = this.getSqlAnnotationType(method);
        if (type == null) {
            return null;
        }
        return SqlCommandType.valueOf(type.getSimpleName().toUpperCase(Locale.ENGLISH));
    }

    private Class<? extends Annotation> getSqlAnnotationType(Method method) {
        return this.chooseAnnotationType(method, this.sqlAnnotationTypes);
    }

    private Class<? extends Annotation> chooseAnnotationType(Method method, List<Class<? extends Annotation>> types) {
        for (Class<? extends Annotation> type : types) {
            Annotation annotation = method.getAnnotation(type);
            if (annotation == null) continue;
            return type;
        }
        return null;
    }
}

