package cn.hperfect.nbquerier.toolkit.map;

import cn.hutool.core.map.CustomKeyMap;
import cn.hutool.core.util.StrUtil;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 转成下划线map
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/12/2 4:02 下午
 */
public class UnderlineCaseMap<V> extends CustomKeyMap<String, V> {

    /**
     * 构造<br>
     * 通过传入一个Map从而确定Map的类型，子类需创建一个空的Map，而非传入一个已有Map，否则值可能会被修改
     *
     * @param m Map 被包装的Map
     * @since 3.1.2
     */
    public UnderlineCaseMap(Map<String, V> m) {
        super(new LinkedHashMap<>(DEFAULT_INITIAL_CAPACITY, DEFAULT_LOAD_FACTOR));
        if (m != null) {
            this.putAll(m);
        }
    }



    @Override
    protected Object customKey(Object key) {
        if (key instanceof CharSequence) {
            key = StrUtil.toUnderlineCase(key.toString());
        }
        return key;
    }
}
