package cn.hperfect.nbquerier.toolkit;

import cn.hutool.core.util.StrUtil;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 1:40 下午
 */
public class SqlUtils {
    /**
     * 携带别名
     *
     * @param alias
     * @param field
     * @return
     */
    public static String withAlias(String alias, String field) {
        if (StrUtil.isNotEmpty(alias)) {
            return StrUtil.concat(false, alias, StringPool.DOT, field);
        }
        return field;
    }

    /**
     * 生成联合主键id (不支持软删除)
     *
     * @param aName
     * @param bName
     * @param unique a,b交换是否可重复
     * @return
     */
    public static String genUnionId(String aName, String bName, boolean unique) {
        if (!unique && StrUtil.compareIgnoreCase(aName, bName, true) < 0) {
            return bName + StringPool.DASH + aName;
        } else {
            return aName + StringPool.DASH + bName;
        }
    }
}
