package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.config.NbQuerierCons;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import lombok.SneakyThrows;

import java.util.List;

public class SqlLoggerUtils {
    /**
     * 日志输入开始
     *
     * @return
     */
    public static StringBuilder loggerStart() {
        StringBuilder logger = new StringBuilder();
        logger.append("\n-----------")
                .append("sql-start")
                .append("----------\n");
        return logger;
    }

    public static String logSql(TimeInterval timer, String sql, List<QueryValParam> params) {
        StringBuilder logger = loggerStart();
        logger.append(logSql(sql, params));
        logEnd(logger, timer);
        return logger.toString();
    }

    /**
     * 日志输入
     *
     * @param sql
     * @param params
     * @return
     */
    public static String logSql(String sql, List<QueryValParam> params) {
        String logSql = sql;
        if (CollUtil.isNotEmpty(params)) {
            List<String> all = ReUtil.findAll(NbQuerierCons.SQL_PARAM_PATTERN, sql, 0);
            for (int i = 0; i < all.size(); i++) {
                String paramStr = all.get(i);
                String indexStr = ReUtil.get(NbQuerierCons.SQL_PARAM_PATTERN, paramStr, 1);
                Assert.notBlank(indexStr, "参数替换失败，占位符不合法:{}", indexStr);
                QueryValParam param = params.get(Convert.toInt(indexStr));
                logSql = StrUtil.replace(logSql, paramStr, getLogValueSql(param.getType(), param.getValue()));
            }
        }
        if (CollUtil.isNotEmpty(params)) {
            for (QueryValParam param : params) {
                logSql = logSql.replaceFirst("\\?", getLogValueSql(param.getType(), param.getValue()));
            }
        }
        return logSql;
    }


    @SneakyThrows
    private static String getLogValueSql(INbQueryType type, Object value) {
        if (value == null) {
            return "null";
        }
        if (type == NbQueryType.TEXT || type == NbQueryType.DATE) {
            return StrUtil.format("'{}'", value);
        } else if (type == NbQueryType.MAP_ENUM) {
            Object convert = NbQueryType.MAP_ENUM.getConvert().convert(value);
            if (convert != null) {
                if (convert instanceof String) {
                    return StrUtil.format("'{}'", convert);
                }
                return convert.toString();
            }
        } else if (type.isJson()) {
            return JSONUtil.toJsonStr(value);
        }
        Object convertValue = type.convert(value);

        if (convertValue == null) {
            return StrUtil.NULL;
        }
        if (type.isArray()) {
            String valueStr = StrUtil.join(",", convertValue);
            return StrUtil.format("array [{}]::{}", valueStr, type.getDbTypeSql());
        }
        return convertValue.toString();
    }
    public static void logEnd(StringBuilder logger,  TimeInterval timer) {
        logger.append("\n----------")
                .append("-sql-end------------")
                .append(StrUtil.format("耗时:{}ms", timer.intervalMs()));
    }
}
