package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.CollUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NbEnumUtils {
    /**
     * 获取枚举值
     *
     * @param fields
     * @param value
     * @param name
     * @return
     */
    public static Object getEnumNewValue(List<? extends INbField> fields, Object value, String name) {
        Map<String, Object> nbEnumType = getNbEnumType(fields, name);
        Object o = getEnumNewValue(value, nbEnumType);
        if (o != null) {
            return o;
        }
        return value;
    }

    private static Object getEnumNewValue(Object value, Map<String, Object> nbEnumType) {
        if (CollUtil.isNotEmpty(nbEnumType) && value != null) {
            if (value instanceof String) {
                Object o = nbEnumType.get(value);
                if (o == null) {
                    throw new NbSQLMessageException("值:{},不合法,可用值:{}", value, nbEnumType);
                }
                return o;
            }
        }
        return value;
    }

    public static List<Object> getEnumListNewValue(List<? extends INbField> fields, Collection<?> valueList, String name) {
        Map<String, Object> nbEnumType = getNbEnumType(fields, name);
        List<Object> newValue = new ArrayList<>();
        if (CollUtil.isNotEmpty(nbEnumType)) {
            for (Object v : valueList) {
                newValue.add(getEnumNewValue(v, nbEnumType));
            }
        }
        return newValue;
    }


    /**
     * 获取类型
     *
     * @param name
     * @return
     */
    public static Map<String, Object> getNbEnumType(List<? extends INbField> fields, String name) {
        INbField one = CollUtil.findOne(fields, i -> i.getName().equals(name));
        assert one instanceof ClassNbField : "枚举属性未找到,属性名称:" + name;
        ClassNbField classNbField = (ClassNbField) one;
        return classNbField.getEnumMap();
    }
}
