package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.type.JsonNbType;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;

/**
 * @author hperfect
 * @date 2022/12/13 21:43
 */
public class JsonValueUtils {

    public static String toStr(JsonNbType jsonNbType, Object value) {
        if (jsonNbType.getVoClass() == null) {
            return StrUtil.toString(value);
        }
        if (jsonNbType.isJsonArray()) {
            return StrUtil.join(";", Convert.toList(jsonNbType.getVoClass(), value));
        } else {
            return Convert.toStr(BeanUtil.toBean(value, jsonNbType.getVoClass()));
        }
    }
}
