package cn.hperfect.nbquerier.toolkit;

import cn.hperfect.nbquerier.core.metedata.QueryItem;
import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/**
 * @author hperfect
 * @date 2023/1/13 17:38
 */
public class FieldParseUtils {

    public static List<QueryItem> parse(String str, boolean parseFunc) {
        List<QueryItem> items = new ArrayList<>();
        //上一个token
        StrBuilder sql = new StrBuilder();

        Stack<QueryItem> itemStack = new Stack<>();
        QueryItem curr = new QueryItem();
        boolean sqlStart = true;
        StrBuilder builder = new StrBuilder();
        for (char ch : str.toCharArray()) {
            if (sqlStart) {
                sql.append(ch);
            }
            //是否是数字
            if ('(' == ch) {
                //创建一个函数并且入栈
                curr.setFunc(true);
                curr.setFuncName(getToken(builder));
                if (itemStack.empty()) {
                    sqlStart = true;
                    items.add(curr);
                }
                //判断是不是根节点
                itemStack.push(curr);
                curr = new QueryItem();
            } else if (')' == ch) {
                //上一个函数结束
                Assert.isTrue(!itemStack.empty(), "括号不匹配");
                QueryItem pop = itemStack.pop();
                if (!builder.isEmpty()) {
                    curr.setName(getToken(builder));
                    pop.addParam(curr);
                    curr = new QueryItem();
                }
                if (itemStack.empty()) {
                    //表示 所有函数结束
                    sqlStart = false;
                }
            } else if ('.' == ch) {
                Assert.notNull(curr, "不能以.开头");
                curr.setTableAlias(getToken(builder));
            } else if (',' == ch) {
                //结束
                //判断是否是函数参数
                if (itemStack.empty()) {
                    finishOnce(parseFunc, builder, sql, curr);
                    sqlStart = true;
                    items.add(curr);
                    curr = new QueryItem();
                } else {
                    if (!builder.isEmpty()) {
                        //上一个item 是个参数
                        curr.setName(builder.toString());
                        itemStack.peek().addParam(curr);
                        curr = new QueryItem();
                    }
                }
            } else {
                //普通字符
                builder.append(ch);
            }
        }
        finishOnce(parseFunc, builder, sql, curr);

        return items;
    }

    private static String getToken(StrBuilder builder) {
        return builder.toString(true);
    }

    private static void finishOnce(boolean parseFunc, StrBuilder builder, StrBuilder sql, QueryItem queryItem) {

        if (!sql.isEmpty() && !parseFunc && queryItem.isFunc()) {
            queryItem.setSql(getToken(sql));
        }
        if (!queryItem.isFunc()) {
            //结束
            queryItem.setName(getToken(builder));
        }
    }


    public static void main(String[] args) {
//        System.out.println(FieldParseUtils.parse("1"));
        StopWatch stopWatch = new StopWatch();
        List<QueryItem> test = new ArrayList<>();
        stopWatch.start("解析字段");
        for (int i = 0; i < 1; i++) {
            //                                            i2  i1
            //( 入栈函数
            // test, ( ,->[i1] count ( ->[i1,i2] 1 ) <-[i2,i1], acd <-[i1]
//            test = FieldParseUtils.simpleParse("COUNT(*) AS follow_count,MAX(create_time) AS last_time,COALESCE(diff_today_days(MAX(r.create_time)), diff_today_days(c.create_time)) AS diff_last_day");
//            test = FieldParseUtils.simpleParse("level,count(*) count,array_agg(principal_id) principal_ids");
            test = FieldParseUtils.simpleParse("ev.view_id, v.table_id, ev.table_id, coalesce(v.title, ev.title) title,view_label");
//            test = FieldParseUtils.simpleParse("select test(count(1),acd) as cc ,(a.c)  b,");
        }
        for (QueryItem queryItem : test) {
            System.out.println(queryItem.getExpr());
        }
        stopWatch.stop();
//        System.out.println(stopWatch.prettyPrint(TimeUnit.MICROSECONDS));
//        System.out.println(FieldParseUtils.parse("COUNT(*) AS follow_count,MAX(create_time) AS last_time,COALESCE(diff_today_days(MAX(m.create_time)), diff_today_days(c.create_time)) AS diff_last_day").parse());
    }

    public static List<QueryItem> simpleParse(String str) {
        StrBuilder builder = new StrBuilder();
        StrBuilder sql = new StrBuilder();
        StrBuilder fieldAlias = new StrBuilder();

        boolean aliasStart = false;
        boolean lastIsS = false;
        List<QueryItem> items = new ArrayList<>();
        QueryItem curr = new QueryItem();
        int level = 0;
        for (char ch : str.toCharArray()) {
            if (ch == '(') {
                boolean isFunc = !builder.isEmpty();
                if (isFunc) {
                    level++;
                    curr.setFunc(true);
                }
            } else if (ch == ')') {
                if (curr.isFunc()) {
                    level--;
                }
            } else if (level == 0) {
                if (ch == ' ') {
                    //下面的都是别名
                    if (aliasStart && !fieldAlias.isEmpty()) {
                        aliasStart = false;
                    } else if (!builder.isEmpty()) {
                        aliasStart = true;
                    }
                } else if (lastIsS && ('A' == ch || 'a' == ch)) {
                    aliasStart = true;
                    //移除上一个s
                    int length = builder.length();
                    builder.del(length - 1, length);
                } else if (ch == '.') {
                    curr.setTableAlias(StrUtil.toUnderlineCase(getToken(builder)));
                } else if (ch == ',') {
                    //结束
                    addItem(sql, builder, fieldAlias, items, curr);
                    curr = new QueryItem();
                    lastIsS = false;
                    aliasStart = false;
                } else {
                    if ('s' == ch || 'S' == ch) {
                        lastIsS = true;
                    }
                    if (aliasStart) {
                        fieldAlias.append(ch);
                    } else {
                        builder.append(ch);
                    }
                }
            }
            if (',' != ch || level > 0) {
                sql.append(ch);
            }
        }
        if (!builder.isEmpty()) {
            addItem(sql, builder, fieldAlias, items, curr);
        }
        //sql
        return items;
    }

    private static void addItem(StrBuilder sql, StrBuilder builder, StrBuilder fieldAlias, List<QueryItem> items, QueryItem curr) {
        if (curr.isFunc()) {
            curr.setSql(getToken(sql));
            curr.setFieldAlias(fieldAlias.toString(true));
        } else {
            curr.setName(getToken(builder));
            curr.setFieldAlias(fieldAlias.toString(true));
        }
        builder.clear();
        sql.clear();
        items.add(curr);
    }


}
