package cn.hperfect.nbquerier.session.impl;

import cn.hperfect.nbquerier.binding.SqlMapperProxy;
import cn.hperfect.nbquerier.config.NbQuerierConfigFactory;
import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.components.executor.INbExecutor;
import cn.hperfect.nbquerier.session.ISqlMapperBuilder;

import java.lang.reflect.Proxy;

public class DefaultNbSqlBuilder implements ISqlMapperBuilder {


    @Override
    @SuppressWarnings("unchecked")
    public <T> T getMapper(Class<T> clazz) {
        NbQuerierConfiguration configuration = NbQuerierConfigFactory.INSTANCE.getConfiguration();
        final SqlMapperProxy<T> mapperProxy = new SqlMapperProxy<>(configuration, clazz);
        return (T) Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, mapperProxy);
    }
}
