package cn.hperfect.nbquerier.service;

import org.springframework.lang.Nullable;

import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/25 2:45 下午
 */
public interface INbService<T> {
    @Nullable
    default T find(Object id) {
        return find(id, null);
    }

    T find(Object id, String nullMsg, Object... params);

    /**
     * 保存
     *
     * @param t
     * @return
     */
    int save(T t);

    /**
     * 通过id更新
     *
     * @param t
     * @return
     */
    int updateById(T t);

    /**
     * 生成sql语句一次性插入(todo 数量大分割)
     *
     * @param list
     * @return
     */
    int saveBatch(List<T> list);

    /**
     * 通过id批量更新
     *
     * @param list
     * @return
     */
    int updateBatchById(List<T> list);

    int removeById(Object id);

    /**
     * 存在id并且数据存在则跟新
     * 明确数据存在不推荐使用该接口
     *
     * @param t
     * @return
     */
    int saveOrUpdate(T t);

}
