package cn.hperfect.nbquerier.service;

import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import org.springframework.transaction.annotation.Transactional;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/25 2:32 下午
 */
public abstract class BaseNbService<T> implements INbService<T> {
    private final Class<T> clazz;

    @SuppressWarnings("unchecked")
    protected BaseNbService() {
        Type t = getClass().getGenericSuperclass();
        ParameterizedType p = (ParameterizedType) t;
        this.clazz = (Class<T>) p.getActualTypeArguments()[0];
    }

    @Override
    public T find(Object id, String nullMsg, Object... params) {
        T t = NbQuerier.table(clazz).find(id);
        Assert.isFalse(t == null && StrUtil.isNotBlank(nullMsg), nullMsg, params);
        return t;
    }

    protected BaseNbService(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public int save(T t) {
        return NbQuerier.table(clazz).save(t);
    }

    @Override
    public int updateById(T t) {
        return NbQuerier.table(clazz).updateById(t);
    }

    @Override
    public int saveBatch(List<T> list) {
        return NbQuerier.table(clazz).saveBatch(list);
    }

    @Override
    @Transactional
    public int updateBatchById(List<T> list) {
        int sum = 0;
        for (T t : list) {
            sum += NbQuerier.table(clazz).updateById(t);
        }
        return sum;
    }

    @Override
    public int removeById(Object id) {
        Assert.notNull(id, "根据id删除，id不能为空");
        return NbQuerier.table(clazz).delete(id);
    }

    @Override
    public int saveOrUpdate(T t) {
        return NbQuerier.table(clazz).saveOrUpdate(t);
    }


}
