package cn.hperfect.nbquerier.exceptions;

import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import lombok.Getter;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/3 3:46 下午
 */
@Getter
public class ConstraintException extends IllegalArgumentException {

    private final INbField field;
    private final String message;

    private final String tableTitle;
    private final String childName;
    public ConstraintException(INbField field, String message) {
        this.message = message;
        this.field = field;
        this.childName = null;
        this.tableTitle = null;
    }


    public ConstraintException(INbField field, String message,String tableTitle) {
        this.message = message;
        this.field = field;
        this.tableTitle = tableTitle;
        this.childName = null;
    }

    public ConstraintException(ClassNbField field, String message, String childName,String tableTitle) {
        this.field = field;
        this.message = message;
        this.tableTitle = tableTitle;
        this.childName = childName;
    }
}
