package cn.hperfect.nbquerier.enums.perm;

/**
 * 权限强制约束
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 10:09 上午
 */
public enum PermType implements IPermType {
    /**
     * 所有用户,没有修改权限
     */
     ALL,
    /**
     * 用户私有级别:加上权限字段(user_id),没有则报错
     */
    SELF,
    /**
     * 租户级别(corp_id)
     */
    TENEMENT,
    /**
     * 租户系统(schema)
     */
    TENEMENT_SYSTEM,
    /**
     * 授权用户,data scope 没有保存
     */
    AUTHORISED,
    /**
     * 自定义,必须在查询构造器中加入
     */
    INPUT,
    ;
}
