package cn.hperfect.nbquerier.enums;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.toolkit.StringPool;
import lombok.AllArgsConstructor;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 4:30 下午
 */
@AllArgsConstructor
public enum SqlKeyword implements ISqlSegment, CharSequence {
    AND("AND"),
    OR("OR"),
    NOT("NOT"),
    IN("IN"),
    ON("ON"),
    NOT_IN("NOT IN"),
    LIKE("LIKE"),
    UNION_ALL("UNION ALL"),
    NOT_LIKE("NOT LIKE"),
    EQ(StringPool.EQUALS),
    NE("<>"),
    GT(StringPool.RIGHT_CHEV),
    GE(">="),
    /**
     * 数组重叠
     */
    ARRAY_OVERLAP("&&"),
    LT(StringPool.LEFT_CHEV),
    LE("<="),
    IS_NULL("IS NULL"),
    IS_NOT_NULL("IS NOT NULL"),
    GROUP_BY("GROUP BY"),
    PARTITION_BY("PARTITION BY"),
    HAVING("HAVING"),
    ORDER_BY("ORDER BY"),
    EXISTS("EXISTS"),
    NOT_EXISTS("NOT EXISTS"),
    BETWEEN("BETWEEN"),
    NOT_BETWEEN("NOT BETWEEN"),
    ASC("ASC"),
    DESC("DESC"),
    LATERAL("LATERAL"),
    OVER("OVER"),
    ANY("ANY"), NULLS("NULLS"),
    TRUE("true");


    private final String keyword;

    @Override
    public String getSqlSegment() {
        return this.keyword;
    }

    @Override
    public int length() {
        return keyword.length();
    }

    @Override
    public char charAt(int index) {
        return keyword.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return keyword.subSequence(start, end);
    }
}
