package cn.hperfect.nbquerier.enums;

import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import lombok.Getter;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/25 2:02 下午
 */
public enum NbOrderType {
    /**
     * 降序
     */
    DESC(SqlKeyword.DESC),
    /**
     * 升序
     */
    ASC(SqlKeyword.ASC),
    ;

    @Getter
    private final SqlKeyword keyword;

    NbOrderType(SqlKeyword keyword) {
        this.keyword = keyword;
    }

    public static NbOrderType parse(String sort) {
        if (DESC.name().equalsIgnoreCase(sort)) {
            return DESC;
        } else if (ASC.name().equalsIgnoreCase(sort)) {
            return ASC;
        }
        throw new NbSQLMessageException("排序类型仅支持:asc,desc,不支持:{}", sort);
    }
}
